<?php
// archivo seguimiento_investigación.php
include 'db_config.php';
include 'encabezado.php';
include 'ver_bene_investigacion.php';
//include "estilos.php";

// Obtener el ID del beneficiario desde la URL
$beneficiario_id = $_GET['beneficiario_id'];

// Obtener la información del beneficiario de la base de datos
$sql_beneficiario = "SELECT nombre_completo, documento_identidad FROM beneficiarios WHERE id = ?";
$stmt = $conn->prepare($sql_beneficiario);
$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$result_beneficiario = $stmt->get_result();

// Recuperar los datos del beneficiario
if ($row = $result_beneficiario->fetch_assoc()) {
    $nombreParticipante = $row['nombre_completo'];
    $documentoIdentidad = $row['documento_identidad'];
} else {
    // Si no se encuentra el beneficiario
    echo "Beneficiario no encontrado.";
    exit;
}

$stmt->close();
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sistema de Gestión de Investigación</title>
</head>
<body>

    <ul>
        <li class="dropdown">
            <a href="" class="dropbtn">Test de Rendimiento Cognitivo</a>
            <div class="dropdown-content">
                <a href="test_memoria.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Test de Memoria Verbal</a>
                <a href="funciones_ejecutivas.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Evaluación de funciones ejecutivas</a>
                <a href="atencion_velocidad_procesamiento.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de atención y velocidad de procesamiento</a>
                <a href="habilidades_visoespaciales.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Evaluaciones de habilidades visoespaciales</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Evaluación de Habilidades Académicas Básicas</a>
            <div class="dropdown-content">
                <a href="comprension_lectora.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de Lectura y Comprensión</a>
                <a href="escritura.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de Escritura</a>
                <a href="matematicas_basicas.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de Matemáticas Básicas</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Indicadores Cognitivos en Tareas Académicas</a>
            <div class="dropdown-content">
                <a href="atencion_concentracion.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Atención y Concentración</a>
                <a href="resolucion_problemas.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Capacidad de Resolución de Problemas</a>
                <a href="retencion.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Retención de Información</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Habilidades y Actitudes para el Aprendizaje Efectivo</a>
            <div class="dropdown-content">
                <a href="motivación_comportamiento.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Observación de Motivación y Comportamiento en el Aula</a>
                <!--a href="progreso_mensual.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>"> Registro de Progreso Mensual</a-->
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Cuestionarios y Autoinformes</a>
            <div class="dropdown-content">
                <a href="bienestar_motivación.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Cuestionario de Bienestar y Motivación</a>
                <a href="logros.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>"> Registro de Logros Personales y Académicos</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Evaluación de Habilidades en Artes</a>
            <div class="dropdown-content">
                <a href="dibujo_pintura.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Habilidades de Dibujo y Pintura</a>
                <a href="escultura_modelado.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Escultura y Modelado</a>
                <a href="ritmo_tempo.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Interpretación Musical Básica</a>
                <a href="danza_expresión_corporal.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Danza y Expresión Corporal</a>
                <a href="expresion_facial_corporal_voz.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Habilidades Teatrales y Expresión Verbal</a>
                
            </div>
        </li>
    </ul>
</nav>
</body>
</html>
