<?php
// archivo seguimiento_investigacion3.php
include 'db_config.php';
include 'index3.php';
include 'ver_bene_investigacion.php';
//include "estilos.php";

// Obtener el ID del beneficiario desde la URL
$beneficiario_id = $_GET['beneficiario_id'];

// Obtener la información del beneficiario de la base de datos
$sql_beneficiario = "SELECT nombre_completo, documento_identidad FROM beneficiarios WHERE id = ?";
$stmt = $conn->prepare($sql_beneficiario);
$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$result_beneficiario = $stmt->get_result();

// Recuperar los datos del beneficiario
if ($row = $result_beneficiario->fetch_assoc()) {
    $nombreParticipante = $row['nombre_completo'];
    $documentoIdentidad = $row['documento_identidad'];
} else {
    // Si no se encuentra el beneficiario
    echo "Beneficiario no encontrado.";
    exit;
}

$stmt->close();
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sistema de Gestión de Investigación</title>
    <!--style type="text/css">
        /* Estilos para el menú */
        ul { list-style-type: none; padding: 0; overflow: hidden; background-color: #333; }
        li { float: left; }
        li a, .dropbtn { display: inline-block; color: white; text-align: center; padding: 14px 16px; text-decoration: none; }
        li a:hover, .dropdown:hover .dropbtn { background-color: #111; }
        .dropdown { display: inline-block; }
        .dropdown-content { display: none; position: absolute; background-color: #f9f9f9; min-width: 200px; box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2); z-index: 1; }
        .dropdown-content a { color: black; padding: 12px 16px; text-decoration: none; display: block; text-align: left; }
        .dropdown-content a:hover { background-color: #f1f1f1; }
        .dropdown:hover .dropdown-content { display: block; }
    </style-->
</head>
<body>

    <ul>
        <li class="dropdown">
            <a href="" class="dropbtn">Test de Rendimiento Cognitivo</a>
            <div class="dropdown-content">
                <a href="test_memoria3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Test de Memoria Verbal</a>
                <a href="funciones_ejecutivas3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Evaluación de funciones ejecutivas</a>
                <a href="atencion_velocidad_procesamiento3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de atención y velocidad de procesamiento</a>
                <a href="habilidades_visoespaciales3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Evaluaciones de habilidades visoespaciales</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Evaluación de Habilidades Académicas Básicas</a>
            <div class="dropdown-content">
                <a href="comprension_lectora3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de Lectura y Comprensión</a>
                <a href="escritura3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de Escritura</a>
                <a href="matematicas_basicas3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Pruebas de Matemáticas Básicas</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Indicadores Cognitivos en Tareas Académicas</a>
            <div class="dropdown-content">
                <a href="atencion_concentracion3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Atención y Concentración</a>
                <a href="resolucion_problemas3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Capacidad de Resolución de Problemas</a>
                <a href="retencion3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Retención de Información</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Habilidades y Actitudes para el Aprendizaje Efectivo</a>
            <div class="dropdown-content">
                <a href="motivación_comportamiento3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Observación de Motivación y Comportamiento en el Aula</a>
                <!--a href="progreso_mensual3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>"> Registro de Progreso Mensual</a-->
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Cuestionarios y Autoinformes</a>
            <div class="dropdown-content">
                <a href="bienestar_motivacion3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Cuestionario de Bienestar y Motivación</a>
                <a href="logros3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>"> Registro de Logros Personales y Académicos</a>
            </div>
        </li>
        <li class="dropdown">
            <a href="" class="dropbtn">Evaluación de Habilidades en Artes</a>
            <div class="dropdown-content">
                <a href="dibujo_pintura3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Habilidades de Dibujo y Pintura</a>
                <a href="escultura_modelado3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Escultura y Modelado</a>
                <a href="ritmo_tempo3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Interpretación Musical Básica</a>
                <a href="danza_expresión_corporal3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Danza y Expresión Corporal</a>
                <a href="expresion_facial_corporal_voz3.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>">Habilidades Teatrales y Expresión Verbal</a>
                
            </div>
        </li>
    </ul>
</nav>
</body>
</html>
