const express = require("express");
const mysql = require("mysql2");

const app = express();
app.use(express.json());
app.use(express.static("public")); // Configura la carpeta pública para archivos frontend

// Configuración de MySQL
const db = mysql.createConnection({
    host: "localhost",
    user: "root", // usuario de MySQL
    password: "", // contraseña de MySQL
    database: "memory_test"
});

db.connect((err) => {
    if (err) throw err;
    console.log("Conectado a la base de datos MySQL");
});

// Endpoint para registrar un resultado de intento
app.post("/api/memory-test", (req, res) => {
    const { beneficiario_id, attempt, recalled_words } = req.body;

    // Obtener la configuración actual del beneficiario
    db.query("SELECT * FROM beneficiarios WHERE beneficiario_id = ?", [beneficiario_id], (err, result) => {
        if (err) throw err;

        const beneficiario = result[0];
        let word_count = beneficiario.max_words;

        // Aumenta el número de palabras si el beneficiario recuerda el 80% o más en el último intento
        if (recalled_words >= 0.8 * word_count) {
            word_count += 2; // Incrementa en 2 palabras
            db.query("UPDATE beneficiarios SET max_words = ? WHERE beneficiario_id = ?", [word_count, beneficiario_id]);
        }

        // Almacenar el resultado del intento en la base de datos
        db.query(
            "INSERT INTO memory_results (beneficiario_id, attempt, recalled_words, word_count) VALUES (?, ?, ?, ?)",
            [beneficiario_id, attempt, recalled_words, word_count],
            (err, result) => {
                if (err) throw err;
                res.json({ message: "Resultado registrado" });
            }
        );
    });
});

// Endpoint para obtener los resultados de un beneficiarioe
app.get("/api/memory-test/:beneficiario_id", (req, res) => {
    const { beneficiario_id } = req.params;
    db.query(
        "SELECT * FROM memory_results WHERE beneficiario_id = ?",
        [beneficiario_id],
        (err, results) => {
            if (err) throw err;
            res.json(results);
        }
    );
});

// Endpoint para crear un nuevo beneficiarioe
app.post("/api/beneficiarios", (req, res) => {
    const { beneficiario_id, max_words, frequency } = req.body;

    db.query(
        "INSERT INTO beneficiarios (beneficiario_id, max_words, frequency) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE max_words=?, frequency=?",
        [beneficiario_id, max_words || 5, frequency || 1, max_words || 5, frequency || 1],
        (err, result) => {
            if (err) throw err;
            res.json({ message: "beneficiario registrado o actualizado" });
        }
    );
});

app.listen(3000, () => {
    console.log("Servidor ejecutándose en http://localhost:3000");
});
