<?php
// archivo submit_test.php
include 'db_config.php';
include_once 'encabezado.php';
//include_once 'estilos.php';
// Archivo: submit_test.php

// Iniciar sesión si no está activa
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Recuperar las palabras presentadas
if (!isset($_SESSION['presented_words'])) {
    echo "Error: Las palabras presentadas no están disponibles.";
    exit;
}

$presentedWords = $_SESSION['presented_words'];
$participantName = $_POST['participant_name'];
$participantId = $_POST['participant_id'];
$modality = $_POST['modalidad_deporte'];
$userAttempts = $_POST['attempt'];

// Validar las respuestas
if (count($userAttempts) !== count($presentedWords)) {
    echo "Error: Número de respuestas incorrecto.";
    exit;
}

// Normalizar las palabras para comparar
$presentedWordsLower = array_map('strtolower', $presentedWords);
$userAttemptsLower = array_map('strtolower', $userAttempts);

// Verificar aciertos
$correctCount = 0;
for ($i = 0; $i < count($presentedWordsLower); $i++) {
    if ($presentedWordsLower[$i] === $userAttemptsLower[$i]) {
        $correctCount++;
    }
}

// Verificar si el participante ya ha realizado el test
$sql = "SELECT * FROM test_entries WHERE participant_id = '$participantId' ORDER BY created_at DESC LIMIT 1";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Test de seguimiento
    $row = $result->fetch_assoc();
    $previousScore = $row['aciertos'];
    $feedback = "Puntaje anterior: $previousScore. ";

    if ($correctCount > $previousScore) {
        $feedback .= "Mejoría en el desempeño.";
    } elseif ($correctCount == $previousScore) {
        $feedback .= "Desempeño estable.";
    } else {
        $feedback .= "Puntaje inferior al anterior.";
    }

    // Resultado de seguimiento
    $resultMessage = "El resultado obtenido en el test de memoria fue $correctCount. Comparativamente con el test anterior, " . strtolower($feedback);
} else {
    // Test inicial
    $resultMessage = "El resultado obtenido en el test inicial de memoria fue $correctCount.";
    $feedback = "Test inicial. Primer intento del participante.";
}

/*$recommendations = "";

if (strtolower($modality) !== 'no participa de la investigacion') {
    // Recomendaciones relacionadas con la actividad física
    switch ($modality) {
        case 'baja intensidad y equilibrio':
            $recommendations = "Te recomendamos continuar con ejercicios de baja intensidad y equilibrio.";
            break;
        case 'resistencia moderada':
            $recommendations = "Los ejercicios de resistencia moderada pueden ayudarte a mejorar tu memoria.";
            break;
        case 'aeróbicos adaptados':
            $recommendations = "Los ejercicios aeróbicos adaptados son beneficiosos para la salud cognitiva.";
            break;
    }
} else {
    // Recomendaciones cognitivas
    $recommendations = "No hay recomendaciones, sobre actividad fisica";
}*/

// Generamos la recomendación basada en los aciertos
    $recommendations = $correctCount >= 4 ? "Excelente memoria verbal, ¡Felicitaciones! Su desempeño demuestra un excelente trabajo en el programa de actividad física, lo que se refleja en sus habilidades cognitivas." : ($correctCount >= 3 ? "Memoria verbal adecuada, Continúe trabajando en la actividad física para fortalecer sus habilidades cognitivas." : "Mejora necesaria, Se sugiere fuertemente poner mucho empeño en la realización de la actividad física con miras a mejorar estas habilidades cognitivas evaluadas en el test de memoria verbal.");

// Guardar los resultados en la base de datos
$sql_insert = "INSERT INTO test_entries (participant_name, participant_id, modalidad_deporte, aciertos, resultado, recomendacion) 
               VALUES ('$participantName', '$participantId', '$modality', '$correctCount', '$resultMessage', '$recommendations')";

if ($conn->query($sql_insert) === TRUE) {
    echo ""; //Resultado guardado correctamente.
} else {
    echo "Error al guardar el resultado: " . $conn->error;
}

// Limpiar las palabras presentadas de la sesión
unset($_SESSION['presented_words']);
?>

<!-- Resumen del test para el usuario -->
<div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Memoria</h3>
    <div class="summary-box">
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participantName) ?></p>
        <p><strong>Puntaje obtenido:</strong> <?= $correctCount ?> aciertos</p>
        <p><strong>Modalidad de deporte:</strong> <?= $modality ?> </p>
        <p><strong>Resultado:</strong> <?= $resultMessage ?></p>
        <p><strong>Recomendaciones:</strong> <?= $recommendations ?></p>
    </div>
</div>

<?php
include "styleres.css";
?>