<?php
session_start();

$problems = [
    'matematicas' => [
        'facil' => [
            ["text" => "¿Cuánto es 2 + 2?", "answer" => 4],
            ["text" => "¿Cuánto es 5 + 3?", "answer" => 8],
            ["text" => "¿Cuánto es 7 - 3?", "answer" => 4],
            ["text" => "¿Cuánto es 6 x 2?", "answer" => 12],
            ["text" => "¿Cuánto es 12 ÷ 4?", "answer" => 3]
        ],
        'medio' => [
            ["text" => "¿Cuánto es 15 ÷ 3?", "answer" => 5],
            ["text" => "¿Cuánto es 3 x 5?", "answer" => 15],
            ["text" => "¿Cuánto es 9 + 8?", "answer" => 17],
            ["text" => "¿Cuánto es 25 - 7?", "answer" => 18],
            ["text" => "¿Cuánto es 16 ÷ 4?", "answer" => 4]
        ],
        'dificil' => [
            ["text" => "¿Cuánto es 23 x 15?", "answer" => 345],
            ["text" => "¿Cuánto es 144 ÷ 12?", "answer" => 12],
            ["text" => "¿Cuánto es 56 x 19?", "answer" => 1064],
            ["text" => "¿Cuánto es 132 ÷ 11?", "answer" => 12],
            ["text" => "¿Cuánto es 39 x 28?", "answer" => 1092]
        ]
    ],
    'logica' => [
        'facil' => [
            ["text" => "Si todos los A son B, y algunos B son C, ¿todos los A son C?", "answer" => "No"],
            ["text" => "¿Cuál es el siguiente número en la secuencia: 2, 4, 6, 8, ...?", "answer" => 10],
            ["text" => "Si María tiene 3 manzanas y Juan tiene 5, ¿cuántas manzanas tienen entre los dos?", "answer" => 8],
            ["text" => "¿Cuántos lados tiene un triángulo?", "answer" => 3],
            ["text" => "¿Cuántos días tiene una semana?", "answer" => 7]
        ],
        'medio' => [
            ["text" => "Si un tren viaja a 60 km/h durante 3 horas, ¿cuál es la distancia recorrida?", "answer" => 180],
            ["text" => "Si todos los gatos son animales, y algunos animales son mamíferos, ¿algunos gatos son mamíferos?", "answer" => "Sí"],
            ["text" => "Si una botella contiene 500 ml de agua y otra botella contiene 300 ml, ¿cuántos ml hay en total?", "answer" => 800],
            ["text" => "Si A es mayor que B, y B es mayor que C, ¿quién es mayor?", "answer" => "A"],
            ["text" => "Si el número 2 es par, ¿qué número es impar?", "answer" => 3]
        ],
        'dificil' => [
            ["text" => "Si todos los A son B y todos los B son C, ¿todos los A son C?", "answer" => "Sí"],
            ["text" => "Si hay 4 manzanas y alguien las reparte entre 2 personas, ¿cuántas manzanas recibe cada persona?", "answer" => 2],
            ["text" => "Si 3 x 4 = 12, ¿cuánto es 4 x 3?", "answer" => 12],
            ["text" => "Si un número es divisible por 2 y por 3, ¿es divisible por 6?", "answer" => "Sí"],
            ["text" => "Si un ángulo tiene 90 grados, ¿cómo se llama?", "answer" => "Ángulo recto"]
        ]
    ],
    'ciencias' => [
        'facil' => [
            ["text" => "¿Quién formuló la teoría de la evolución?", "answer" => "Charles Darwin"],
            ["text" => "¿Qué tipo de animal es el delfín?", "answer" => "Mamífero"],
            ["text" => "¿Cómo se llama el proceso de cambio de agua a vapor?", "answer" => "Evaporación"],
            ["text" => "¿Cómo se llama el proceso de formación de rocas ígneas?", "answer" => "Enfriamiento y solidificación"],
            ["text" => "¿Qué gas es el principal responsable del cambio climático?", "answer" => "Dióxido de carbono"]
        ],
        'dificil' => [
            ["text" => "¿Quién formuló la ley de la gravedad?", "answer" => "Isaac Newton"],
            ["text" => "¿Qué es la teoría de la relatividad?", "answer" => "Una teoría sobre la gravedad y el espacio-tiempo de Einstein"],
            ["text" => "¿Qué es un agujero negro?", "answer" => "Una región del espacio con gravedad extremadamente fuerte"],
            ["text" => "¿Quién descubrió la estructura del ADN?", "answer" => "James Watson y Francis Crick"],
            ["text" => "¿Cuántos elementos químicos existen actualmente?", "answer" => 118],
            ["text" => "¿Qué es la fotosíntesis?", "answer" => "Proceso por el cual las plantas convierten la luz en energía"],
            ["text" => "¿Qué es un quásar?", "answer" => "Una fuente de energía en el centro de algunas galaxias"],
            ["text" => "¿Qué científico propuso la teoría del Big Bang?", "answer" => "Georges Lemaître"],
            ["text" => "¿Qué teoría explica la formación de las galaxias?", "answer" => "Teoría de la relatividad general"],
            ["text" => "¿Cómo se llama la capa de gases que rodea la Tierra?", "answer" => "Atmósfera"]
        ]
    ]
];

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test de Problemas</title>
</head>
<body>
    <h1>Test de Problemas</h1>

    <form action="test.php" method="POST">
        <label for="categoria">Elige una categoría:</label>
        <select name="categoria" id="categoria">
            <option value="matematicas">Matemáticas</option>
            <option value="logica">Lógica</option>
            <option value="ciencias">Ciencias</option>
        </select>

        <br><br>

        <label for="dificultad">Elige una dificultad:</label>
        <select name="dificultad" id="dificultad">
            <option value="facil">Fácil</option>
            <option value="medio">Medio</option>
            <option value="dificil">Difícil</option>
        </select>

        <br><br>

        <input type="submit" value="Comenzar Test">
    </form>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $categoria = $_POST['categoria'];
        $dificultad = $_POST['dificultad'];

        $_SESSION['categoria'] = $categoria;
        $_SESSION['dificultad'] = $dificultad;

        $selected_problems = $problems[$categoria][$dificultad];
        $_SESSION['selected_problems'] = $selected_problems;

        echo '<h2>Test de ' . ucfirst($categoria) . ' - Dificultad ' . ucfirst($dificultad) . '</h2>';

        foreach ($selected_problems as $index => $problem) {
            echo '<p>' . ($index + 1) . '. ' . $problem['text'] . '</p>';
            echo '<input type="text" name="respuesta[' . $index . ']" />';
        }

        echo '<br><br>';
        echo '<input type="submit" value="Enviar Respuestas">';
    }
    ?>
</body>
</html>
