<?php 
// Archivo: test_memoria3.php
include 'db_config.php';
include 'index3.php';
//include "estilos.php"; 

// Obtener el nombre del participante desde el parámetro GET
$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante

// Palabras disponibles para mostrar
$allWords = ["Casa", "Sol", "Perro", "Luna", "Flor", "Montaña", "Rosa", "Arbol", "Gato", "Mar"];

// Seleccionar aleatoriamente 5 palabras
shuffle($allWords);
$words = array_slice($allWords, 0, 5);

// Guardar las palabras seleccionadas en una sesión para mantener la coherencia en submit_test.php
if (session_status() == PHP_SESSION_NONE) {
    session_start(); // Iniciar sesión solo si no está activa
}

$_SESSION['presented_words'] = $words; // Guardar las palabras presentadas en la sesión
?>

<!DOCTYPE html>
<html lang="es">
<header class="main-header">
    <meta charset="UTF-8">
    <title>Test de Memoria Verbal Adaptado</title>
    <link rel="stylesheet" href="style.css">
    <script>
        let timer;
        function startTimer() {
            const minutes = document.getElementById('display_time').value;
            const milliseconds = minutes * 60000;
            clearTimeout(timer);
            timer = setTimeout(() => {
                document.getElementById('memory-content').style.display = 'none';
                alert("El tiempo ha terminado. Haga clic para que Las imágenes y palabras sean ocultadas.");
            }, milliseconds);
        }
    </script>
    <style>
        
        #memory-content {
            margin-top: 20px;
        }
        .word-item {
            display: inline-block;
            margin: 10px;
            text-align: center;
        }
        .word-item img {
            width: 100px;
            height: 100px;
        }
        button {
            margin-top: 10px;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <h1>Test de Memoria Verbal Adaptado</h1>
    <p>Recuerda las siguientes palabras e imágenes:</p>
    
    <label for="display_time">Tiempo en minutos para mostrar imágenes:</label>
    <select id="display_time" name="display_time">
        <option value="1">1 minuto</option>
        <option value="2">2 minutos</option>
        <option value="3">3 minutos</option>
        <option value="5">5 minutos</option>
    </select>
    <br><br>
    
    <button onclick="startTimer()">Iniciar Temporizador</button>

    <div id="memory-content">
        <?php
        foreach ($words as $word) {
            echo "<div class='word-item'>";
            echo "<img src='uploads/fotos/{$word}.png' alt='{$word}' />";
            echo "<p>{$word}</p>";
            echo "</div>";
        }
        ?>
    </div>

    <form action="submit_test3.php" method="post">
        <label for="participant_name">Nombre del Beneficiario:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" readonly>

        <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" readonly>
        
        <label for="modalidad_deporte">Modalidad de Actividad Física:</label><br>
        <select id="modalidad_deporte" name="modalidad_deporte">
            <option value="ninguna">Ninguna modalidad</option>
            <option value="baja intensidad y equilibrio">Ejercicios de baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Ejercicios de resistencia moderada</option>
            <option value="aerobicos adaptados">Ejercicios aeróbicos adaptados</option>
        </select><br><br>

        <?php foreach ($words as $index => $word): ?>
            <label for="attempt_<?= $index ?>">Palabra <?= $index + 1 ?>:</label>
            <input type="text" id="attempt_<?= $index ?>" name="attempt[]" style="text-transform: lowercase;" required>
        <?php endforeach; ?>
        <br><br>
        
        <input type="submit" value="Enviar Respuestas">
    </form>

    <br> <br>
</body>
</html>
