<?php
ob_start();
require_once 'db_config.php';
include "index.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Validación y saneamiento de entradas
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if ($id <= 0) {
        die("ID inválido.");
    }

    // Construir dinámicamente la consulta de actualización
    $campos = [];
    $valores = [];

    // Los campos permitidos deben coincidir exactamente con los nombres de los inputs del formulario
    $permitidos = [
        'nombre_completo',
        'documento_identidad',  // Se usa mayúscula inicial para coincidir con el formulario
        'fecha_nacimiento',
        'correo_electronico',
        'acudiente',
        'institucion_patrocinadora',
        'grupo',
        'programa',
        'modalidad',
        'sede',
        'diagnosis'
    ];

    foreach ($permitidos as $campo) {
        if (isset($_POST[$campo])) { // Actualizamos si el campo fue enviado, incluso si está vacío
            $campos[] = "$campo = ?";
            $valores[] = $conn->real_escape_string($_POST[$campo]);
        }
    }

    if (empty($campos)) {
        die("No se han proporcionado datos para actualizar.");
    }

    // Agregar el ID para la cláusula WHERE
    $valores[] = $id;

    // Construir la consulta SQL de forma dinámica
    $sql = "UPDATE beneficiarios SET " . implode(", ", $campos) . " WHERE id = ?";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Error al preparar la consulta: " . $conn->error);
    }
    
    // Generar dinámicamente el string de tipos (asumimos todos como string, salvo el ID)
    $tipos = str_repeat("s", count($valores) - 1) . "i";

    $stmt->bind_param($tipos, ...$valores);

    if ($stmt->execute()) {
        header("Location: view.php?id=" . $id);
        exit;
    } else {
        echo "Error al actualizar: " . $stmt->error;
    }
    
    $stmt->close();
} else {
    echo "Método no permitido.";
}

ob_end_flush();
?>
