<?php
include 'db_config.php';
include "encabezado.php";


// Obtener el ID del estudiante desde la URL
$beneficiario_id = $_GET['id'];

// Obtener la evaluación seleccionada (si se ha seleccionado alguna)
if (isset($_GET['seguimiento_id'])) {
    $seguimiento_id = $_GET['seguimiento_id'];
    
    // Consulta para obtener los detalles de la evaluación seleccionada
    $sql_selected_seguimiento = "SELECT * FROM seguimientos WHERE id = $seguimiento_id AND beneficiario_id = $beneficiario_id";
    $result_selected_seguimiento = $conn->query($sql_selected_seguimiento);

    // Verificar si se ha encontrado la evaluación
    if ($result_selected_seguimiento->num_rows > 0) {
        $selected_seguimiento = $result_selected_seguimiento->fetch_assoc();
    } else {
        echo "No se encontró el seguimiento seleccionado.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Versión Imprimible y PDF Idénticos</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      margin: 0;
      padding: 20px;
      background: #f2f2f2;
    }
    /* Contenedor que se usará tanto para imprimir como para PDF */
    #printableVersion {
      width: 210mm; /* Ancho A4 */
      max-width: 100%;
      margin: auto;
      padding: 20px;
      background: #fff;
      border: 1px solid #000;
      text-align: left;
      font-size: 12px; /* Ajusta el tamaño de fuente según necesites */
    }
    textarea {
      font-size: 12px;
      width: 100%;
      height: 150px;
    }
    button {
      margin: 10px 5px;
      padding: 10px 15px;
      font-size: 16px;
      background-color: blue;
      color: white;
      border: none;
      cursor: pointer;
    }
    /* Estilos de impresión: se usan los mismos estilos para que luzca igual */
    @media print {
      body, #printableVersion {
        margin: 0;
        padding: 0;
        border: none;
        width: auto;
      }
      button {
        display: none;
      }
    }
  </style>
</head>
<body>

  <div style="margin-bottom: 20px;">
    <button onclick="window.print()">Imprimir</button>
    <button onclick="generatePDF()">Descargar PDF</button>
  </div>
    <!--h1>Sistema de Gestión de Beneficiarios</h1-->
<table>
     <div id="printableVersion">

<?php
include 'ver_beneficiario.php';
?>
    <!-- Mostrar la evaluación seleccionada si existe -->
    <?php if (isset($selected_seguimiento)): ?>

        <label>Evaluador:</label>
        <input type="text" readonly value="<?php echo htmlspecialchars($selected_seguimiento['evaluador']); ?>"><br>
        
        <label>Asignatura:</label>
        <input type="text" readonly value="<?php echo htmlspecialchars($selected_seguimiento['asignatura']); ?>"><br>
        
        <label>Fecha del Seguimiento:</label>
        <input type="text" readonly value="<?php echo htmlspecialchars($selected_seguimiento['fecha_evaluacion']); ?>"><br>        

        <label>Desarrollo Cognitivo:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['desarrollo_cognitivo']); ?></textarea><br>

        <label>Habilidades Sociales:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['habilidades_sociales']); ?></textarea><br>

        <label>Autonomia:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['autonomia']); ?></textarea><br>

        <label>Desempeño Académico:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['desempeño_academico']); ?></textarea><br>
    <div style="height: 100px;"></div> 
        <label>Competencia Lectoescritora:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['competencia_lectoescritura']); ?></textarea><br>
   
        <label>Matematica Basica:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['matematica_basica']); ?></textarea><br>

        <label>Habilidades Organizacionales:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['habilidades_organizacionales']); ?></textarea><br>

        <label>Apreciación Integral, Diagnóstico Funcional e identificación de necesidades:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['apreciacion']); ?></textarea><br>
        
        <label>Objetivos Específicos del Periodo:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['objetivos']); ?></textarea><br>
        
        <label>Ajustes Razonables:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['ajustes_razonables']); ?></textarea><br>
     <div style="height: 150px;"></div>         
        <label>Plan de Acción y Estrategia de Intervención:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['plan_accion']); ?></textarea><br>
      
        <label>Periodicidad de este seguimiento:</label>
        <input type="text" readonly value="<?php echo htmlspecialchars($selected_seguimiento['periodicidad']); ?>"><br>

        <label>Recomendaciones:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['recomendaciones']); ?></textarea><br>

        <label>Observaciones:</label>
        <textarea readonly><?php echo htmlspecialchars($selected_seguimiento['observaciones']); ?></textarea><br><br><br><br><br><br>
    <!-- Agregamos un poco de espacio extra para evitar que el texto quede pegado al borde -->
        
</div>
</table>
    <?php endif; ?>

    <!-- Formulario para añadir una nueva evaluación -->
    <h2>Añadir Nuevo Seguimiento</h2>
    <form action="add_Nuevoseguimiento.php" method="post">

        <input type="hidden" name="beneficiario_id" value="<?php echo $beneficiario_id; ?>">
        <label for="evaluador">Profesional:<span class="error"style='color:red'>*<span/></label>
        <input type="text" id="evaluador" name="evaluador" required title="Digite el nombre de la persona que hace el seguimiento" size="40%" ><br><br>
        <label for="asignatura">Asignatura:<span class="error"style='color:red'>*<span/> </label>
        <input type="text" name="asignatura" required title="Digite el nombre de su asignatura"><br><br>
        <label for="fecha_evaluacion" >Fecha de seguimiento:<span class="error"style='color:red'>*<span/></label>
        <input type="date" name="fecha_evaluacion" required title="Seleccione la fecha de realización de la seguimiento"><br><br>
        <label for="desarrollo_cognitivo" > Desarrollo Cognitivo:</label><br>
        <textarea name="desarrollo_cognitivo" cols="35%" rows="5" title="Describa de manera detallada el desarroll Cognitivo del beneficiario/a" ></textarea><br><br>
        <label for="habilidades_sociales" > Habilidades Sociales:</label><br>
        <textarea name="habilidades_sociales" cols="35%" rows="5" title="Describa de manera detallada las habilidades sociales del beneficiario/a" ></textarea><br><br>
        <label for="autonomia" > Autonomia:</label><br>
        <textarea name="autonomia" cols="35%" rows="5" title="Describa de manera detallada como es la autonomia del beneficiario/a" ></textarea><br><br>
        <label for="desempeño_academico" > Desempeño Academico:</label><br>
        <textarea name="desempeño_academico" cols="35%" rows="5" title="Describa de manera detallada como es el desempeño académico del beneficiario/a" ></textarea><br><br>
        <label for="competencia_lectoescritura" > Competencia Lectoescritora:</label><br>
        <textarea name="competencia_lectoescritura" cols="35%" rows="5" title="Describa de manera detallada como es competencia lectoescritora del beneficiario/a" ></textarea><br><br>
        <label for="matematica_basica" > Matematica Basica:</label><br>
        <textarea name="matematica_basica" cols="35%" rows="5" title="Describa de manera detallada como es competencia en matematica basica del beneficiario/a" ></textarea><br><br>
        <label for="habilidades_organizacionales" > Habilidades Organizacionales:</label><br>
        <textarea name="habilidades_organizacionales" cols="35%" rows="5" title="Describa de manera detallada como son las habilidades organizacionales del beneficiario/a" ></textarea><br><br>
        <label for="apreciacion" > Apreciación Integral, Diagnóstico Funcional e identificación de necesidades:<span class="error"style='color:red'>*<span/></label><br>
         <textarea name="apreciacion" cols="85%" rows="15" required title="Escriba sus consideraciones generales de acuerdo con la condición actual del beneficiario, considerando su neuro desarrollo, condiciones clínicas y necesidades especiales" ></textarea><br><br>
         <label for="objetivos" > Objetivos del periodo:<span class="error"style='color:red'>*<span/></label><br>
         <textarea name="objetivos" cols="35%" rows="5" required title="Escriba los objetivos propuestos para este periodo" ></textarea><br><br>
         <label for="ajustes_razonables" >Ajustes Razonables:<span class="error"style='color:red'>*<span/></label><br>
         <textarea name="ajustes_razonables"cols="85%" rows="15" required title="Describa cuales serian los Ajustes Razonables que el alumno necesita para lograr los objetivos del periodo."></textarea><br><br>
        <label for="plan_accion" > Plan de Acción:<span class="error"style='color:red'>*<span/></label><br>
        <textarea name="plan_accion" cols="85%" rows="15" required title="Describa de manera detallada el plan de accion de su asignatura para que el alumno pueda lograr los objetivos del periodo." ></textarea><br><br>
         <label for="diagnosis">Periodicidad del seguimiento:</label><br>
            <select id="periodicidad" name="periodicidad" title="Seleccione la periodicidad">
                <option value="mensual">Mensual</option>
                <option value="trimestral">Trimestral</option>
                <option value="semestral">Semestral </option>
                <option value="anual">Anual </option>
            </select><br>
        <label for="recomendaciones" > Recomendaciones:</label><br>
        <textarea name="recomendaciones" cols="35%" rows="5" title="Describa de manera detallada las recomendaciones que hace al beneficiario/a" ></textarea><br><br>

        <label for="observaciones" > Observaciones:</label><br>
        <textarea name="observaciones" cols="35%" rows="5" title="Describa de manera detallada las observaciones que hace al beneficiario/a" ></textarea><br><br>
        <input type="submit" value="Añadir seguimiento">
    </form><br><br><br>
</head>
<body>
    <script>
        async function generatePDF() {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF({ orientation: "portrait", unit: "mm", format: "a4" });

            const element = document.getElementById("printableVersion");

            await doc.html(element, {
                callback: function (doc) {
                    doc.save("informe_seguimiento.pdf");
                },
                x: 10,
                y: 10,
                width: 190, // Ajusta al ancho de la página A4 sin distorsionar
                windowWidth: element.scrollWidth // Evita que el texto se agrande demasiado
            });
        }
    </script>
</body>
</html>
