<?php
// Incluir configuración de la base de datos
include 'db_config.php';

// Verificar si el formulario ha sido enviado mediante el método POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Obtener los datos enviados desde el formulario
    $beneficiario_id = $_POST['beneficiario_id'];
    $evaluador = $_POST['evaluador'];
    $asignatura = $_POST['asignatura'];
    $fecha_evaluacion = $_POST['fecha_evaluacion'];
    $apreciacion = $_POST['apreciacion'];
    $objetivos = $_POST['objetivos'];
    $ajustes_razonables = $_POST['ajustes_razonables'];
    $plan_accion = $_POST['plan_accion'];
    $periodicidad = $_POST['periodicidad'];
    $recomendaciones = $_POST['recomendaciones'];
    $observaciones = $_POST['observaciones'];

    // Validación de los campos obligatorios
    if (empty($evaluador) || empty($asignatura) || empty($fecha_evaluacion) || empty($apreciacion) || empty($ajustes_razonables) || empty($plan_accion)) {
        echo "Por favor, completa todos los campos obligatorios.";
        exit();
    }

    // Preparar la consulta para insertar un nuevo seguimiento en la base de datos
    $sql = "INSERT INTO seguimientos (beneficiario_id, evaluador, asignatura, fecha_evaluacion, apreciacion, objetivos, ajustes_razonables, plan_accion, periodicidad, recomendaciones, observaciones)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    // Preparar y ejecutar la consulta utilizando una declaración preparada para evitar inyecciones SQL
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issssssssss", $beneficiario_id, $evaluador, $asignatura, $fecha_evaluacion, $apreciacion, $objetivos, $ajustes_razonables, $plan_accion, $periodicidad, $recomendaciones, $observaciones);

    // Ejecutar la consulta y verificar si se insertó correctamente
    if ($stmt->execute()) {
        echo "Seguimiento añadido con éxito.";
        header("Location: seguimiento_beneficiario.php?beneficiario_id=$beneficiario_id");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }

    // Cerrar la declaración y la conexión
    $stmt->close();
    $conn->close();
} else {
    // Redirigir si se intenta acceder a este archivo directamente
    header("Location: index.php");
    exit();
}
?>
