<?php
// archivo view.php
require_once 'db_config.php';
//require "index.php";

// Verificamos que se reciba el ID por GET
if (!isset($_GET['id'])) {
    die("ID no especificado.");
}
$beneficiario_id = intval($_GET['id']);

// Consulta a la tabla 'beneficiarios' para obtener la información básica del estudiante
$stmt = $conn->prepare("SELECT * FROM beneficiarios WHERE id = ?");
$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    die("Beneficiario no encontrado.");
}
$beneficiario = $result->fetch_assoc();
$stmt->close();

// Definimos el participant_id para las consultas (usamos el documento de identidad)
$participant_id = $beneficiario['documento_identidad'];

// Consulta a la tabla evaluacion_impacto para obtener el registro más reciente (evaluación académica)
$stmt_eval = $conn->prepare("SELECT * FROM evaluacion_impacto WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $evaluacion = $result_eval->fetch_assoc();
} else {
    $evaluacion = null;
}
$stmt_eval->close();

// Consulta a la tabla cuestionarios_satisfaccion para obtener la información de bienestar y motivación
$stmt_cu = $conn->prepare("SELECT * FROM cuestionarios_satisfaccion WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_cu->bind_param("s", $participant_id);
$stmt_cu->execute();
$result_cu = $stmt_cu->get_result();
if ($result_cu->num_rows > 0) {
    $cuestionario = $result_cu->fetch_assoc();
} else {
    $cuestionario = null;
}
$stmt_cu->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM lectura_comprensión WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $lectura = $result_eval->fetch_assoc();
} else {
    $lectura = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM escritura WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $escritura = $result_eval->fetch_assoc();
} else {
    $escritura = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM matematicas_basicas WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $matematicas = $result_eval->fetch_assoc();
} else {
    $matematicas = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM test_entries WHERE participant_id = ? ORDER BY created_at DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $memoria = $result_eval->fetch_assoc();
} else {
    $memoria = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM funciones_ejecutivas WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $funciones = $result_eval->fetch_assoc();
} else {
    $funciones = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM visuoespacial_results WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $visoespacial = $result_eval->fetch_assoc();
} else {
    $visoespacial = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM atencion_concentracion WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $atencion = $result_eval->fetch_assoc();
} else {
    $atencion = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM resolucion_problemas WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $problemas = $result_eval->fetch_assoc();
} else {
    $problemas = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM resultados_retencion WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $retencion = $result_eval->fetch_assoc();
} else {
    $retencion = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM dibujo_pintura WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $dibujo = $result_eval->fetch_assoc();
} else {
    $dibujo = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM escultura_modelado WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $escultura = $result_eval->fetch_assoc();
} else {
    $escultura = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM ritmo_tempo WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $musica = $result_eval->fetch_assoc();
} else {
    $musica = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM danza_expresion_corporal WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $danza = $result_eval->fetch_assoc();
} else {
    $danza = null;
}
$stmt_eval->close();

// Preparamos la consulta a la tabla evaluacion_impacto para obtener el registro más reciente para este participante
$stmt_eval = $conn->prepare("SELECT * FROM expresion_teatral WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1");
$stmt_eval->bind_param("s", $participant_id);
$stmt_eval->execute();
$result_eval = $stmt_eval->get_result();
if ($result_eval->num_rows > 0) {
    $teatro = $result_eval->fetch_assoc();
} else {
    $teatro = null;
}
$stmt_eval->close();

// Función que devuelve la descripción de la evaluación para aspectos académicos (preguntas 1 a 10)
function getEvaluationDescription($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Participación en clases:</strong>El estudiante apenas interviene en clase, muestra muy poca iniciativa y se mantiene al margen de las actividades grupales.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Participación en clases:</strong>Participa de forma ocasional, interviniendo cuando se le solicita.";
            } else {
                return "<strong>Participación en clases:</strong>Participa activamente, aportando ideas y fomentando el debate.";
            }
        case 2:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Atención:</strong>Presenta dificultades para mantener la atención y se distrae con facilidad.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Atención:</strong>Muestra atención intermitente, concentrándose en ocasiones.";
            } else {
                return "<strong>Atención:</strong>Mantiene una excelente atención, siguiendo las indicaciones sin distracciones.";
            }
        case 3:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante los desafíos:</strong>Evita enfrentar desafíos y muestra poco interés en superar obstáculos.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Actitud ante los desafíos:</strong>Acepta algunos desafíos, pero a veces necesita apoyo para superarlos.";
            } else {
                return "<strong>Actitud ante los desafíos:</strong>Enfrenta los desafíos con entusiasmo y determinación.";
            }
        case 4:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud para aprender:</strong>Presenta una actitud pasiva hacia el aprendizaje y muestra escaso interés.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Actitud para aprender:</strong>Demuestra interés por aprender, aunque su iniciativa es moderada.";
            } else {
                return "<strong>Actitud para aprender:</strong>Está altamente motivado y se involucra de manera constante en su aprendizaje.";
            }
        case 5:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Compañerismo:</strong>Tiene dificultades para trabajar en equipo y se aísla de sus compañeros.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Compañerismo:</strong>Interactúa de forma ocasional y cumple con las tareas en grupo.";
            } else {
                return "<strong>Compañerismo:</strong>Es ejemplar en compañerismo, fomenta la cooperación y apoya a sus compañeros.";
            }
        case 6:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante las adversidades:</strong>Se desanima fácilmente ante las adversidades, mostrando una respuesta negativa.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Actitud ante las adversidades:</strong>Enfrenta las adversidades de manera moderada, con cierta dificultad para recuperarse.";
            } else {
                return "<strong>Actitud ante las adversidades:</strong>Afronta las adversidades con fortaleza y aprende de los contratiempos.";
            }
        case 7:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resolutividad:</strong> Depende en gran medida de la ayuda externa para resolver problemas.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Resolutividad:</strong> Resuelve problemas en situaciones conocidas, pero puede dudar en nuevas circunstancias.";
            } else {
                return "<strong>Resolutividad:</strong> Destaca por su habilidad para encontrar soluciones creativas y actuar de forma autónoma.";
            }
        case 8:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Organización en sus actividades diarias:</strong>Muestra una organización deficiente, lo que repercute negativamente en su rendimiento.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Organización en sus actividades diarias:</strong>Posee una organización moderada, aunque podría mejorar en mantener un orden constante.";
            } else {
                return "<strong>Organización en sus actividades diarias:</strong>Es muy organizado, establece rutinas efectivas y maneja su tiempo de forma óptima.";
            }
        case 9:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resiliencia:</strong>Presenta baja resiliencia y se desanima ante los fracasos.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Resiliencia:</strong>Muestra cierta resiliencia, aunque en situaciones críticas su recuperación es limitada.";
            } else {
                return "<strong>Resiliencia:</strong>Demuestra alta resiliencia, afrontando las dificultades con optimismo y aprendiendo de sus errores.";
            }
        case 10:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Incumple frecuentemente sus deberes escolares, mostrando falta de compromiso.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Cumple en su mayoría con sus deberes, aunque ocasionalmente requiere recordatorios.";
            } else {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Es altamente responsable, cumpliendo puntualmente con sus tareas y demostrando un gran compromiso.";
            }
        default:
            return "";
    }
}

// Función que devuelve un comentario para bienestar (question 1) y motivación (question 2) según la escala
function getEvaluationDescription2($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Bienestar
            if ($score <= 2) {
                return "<strong>Bienestar:</strong>Manifiesta un nivel bajo de satisfacción personal, sintiéndose insatisfecho con sus logros y relaciones.";
            } elseif ($score == 3) {
                return "<strong>Bienestar:</strong>Manifiesta una satisfacción personal moderada, reconociendo tanto sus fortalezas como áreas de mejora.";
            } else {
                return "<strong>Bienestar:</strong>Se percibe altamente satisfecho consigo mismo, mostrando confianza, optimismo y solidez emocional.";
            }
        case 2: // Motivación
            if ($score <= 2) {
                return "<strong>Motivación:</strong>Manifiesta niveles bajos de motivación, evidenciando escasa iniciativa para comprometerse con sus metas.";
            } elseif ($score == 3) {
                return "<strong>Motivación:</strong>Manifiesta una motivación moderada, con momentos de compromiso y otros de inercia.";
            } else {
                return "<strong>Motivación:</strong>Se percibe altamente motivado, demostrando energía, compromiso y clara orientación hacia sus metas.";
            }
        default:
            return "";
    }
}

// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription3($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:// Comprensión Lectora
            if ($score <= 1 ) {
                return "<strong>Comprensión Lectora:</strong>Presenta dificultades significativas para comprender textos; le cuesta extraer la información principal y conectar ideas, lo que afecta su capacidad para interpretar y analizar lo leído.";
            } elseif ($score == 2 ) {
                return "<strong>Comprensión Lectora:</strong>Logra comprender textos sencillos y extraer la información básica, aunque en textos más complejos se evidencia cierta dificultad para identificar detalles y relaciones entre ideas.";
            } else {
                return "<strong>Comprensión Lectora:</strong>Demuestra una excelente capacidad de comprensión lectora, interpretando y analizando textos complejos de manera precisa, identificando ideas principales, inferencias y detalles con gran claridad.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription4($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Escritura
            if ($score  >= 0 && $score <= 2 ) {
                return "<strong>Escritura:</strong> Tiene serias dificultades para estructurar sus ideas de forma coherente y clara; se observan errores gramaticales y ortográficos frecuentes, lo que dificulta la comunicación efectiva,";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Escritura:</strong>Redacta textos comprensibles y con un nivel aceptable de coherencia, aunque aún presenta algunos errores de forma y contenido que requieren mejorar para alcanzar una mayor claridad y fluidez,";
            } else {
                return "<strong>Escritura:</strong>Escribe con gran claridad y coherencia, utilizando un lenguaje preciso y estructurando sus ideas de forma lógica y organizada, lo que facilita la comunicación de sus pensamientos de manera efectiva,";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription5($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Matemáticas Básicas
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Matemáticas Básicas:</strong>Muestra dificultades considerables en la resolución de operaciones básicas y en la aplicación de conceptos matemáticos elementales, evidenciando una comprensión limitada de los fundamentos.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Matemáticas Básicas:</strong>Resuelve problemas matemáticos básicos con precisión moderada; aunque entiende los conceptos fundamentales, ocasionalmente comete errores en cálculos o en la aplicación de procedimientos.";
            } else {
                return "<strong>Matemáticas Básicas:</strong>Demuestra una destacada habilidad para resolver problemas matemáticos básicos, con rapidez y precisión, y entiende de forma clara y profunda los conceptos fundamentales, lo que le permite aplicar los procedimientos de manera eficaz.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription6($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Memoria
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Memoria:</strong>Muestra dificultades considerables para retener y recuperar información, lo que impacta negativamente en su aprendizaje y desempeño diario.";
            } elseif ($aciertos >= 3 && $aciertos <= 4 ) {
                return "<strong>Memoria:</strong>Tiene una capacidad de memoria funcional, que le permite retener información básica, aunque puede presentar dificultades con datos complejos o bajo alta distracción.";
            } else {
                return "<strong>Memoria:</strong>Demuestra una excelente retención y recuperación de información, aplicando eficazmente lo aprendido en diversas situaciones.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription7($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Funciones Ejecutivas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Funciones Ejecutivas:</strong>Sus funciones ejecutivas son limitadas; muestra dificultades en la planificación, organización y toma de decisiones, lo que afecta su capacidad para gestionar tareas complejas.";
            } elseif ($aciertos >= 3 && $aciertos <= 4 ) {
                return "<strong>Funciones Ejecutivas:</strong>Cuenta con un desempeño adecuado en funciones ejecutivas, siendo capaz de planificar y organizar sus actividades, aunque a veces necesita apoyo en la toma de decisiones.";
            } else {
                return "<strong>Funciones Ejecutivas:</strong>Destaca por una excelente capacidad de planificación, organización y toma de decisiones, lo que le permite afrontar retos de forma autónoma y eficaz.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription8($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Habilidades Visoespaciales
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Habilidades Visoespaciales:</strong>Tiene dificultades para percibir y manipular la información visual; su coordinación ojo-mano es limitada, afectando tareas que requieren precisión.";
            } elseif ($aciertos >= 3 && $aciertos <= 4 ) {
                return "<strong>Habilidades Visoespaciales:</strong>Posee habilidades visoespaciales aceptables, permitiéndole interpretar y organizar información visual de forma funcional, aunque con margen de mejora en precisión y rapidez.";
            } else {
                return "<strong>Habilidades Visoespaciales:</strong>Demuestra una aguda percepción visoespacial, interpretando y manipulando la información visual con gran precisión y rapidez.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription9($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Atención concentración
            if ($aciertos == 2  ) {
                return "<strong>Atención y concentración:</strong>Presenta marcada distracción y dificultad para mantener la atención, lo que interfiere significativamente en su capacidad para realizar tareas.";
            } elseif ($aciertos >= 5 && $aciertos <=10  ) {
                return "<strong>Atención y concentración:</strong>Logra mantener la atención en situaciones sencillas, aunque puede fluctuar en entornos con múltiples estímulos.";
            } else {
                return "<strong>Atención y concentración:</strong>Mantiene una excelente concentración, enfocándose de manera sostenida en las tareas y minimizando distracciones.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription10($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Resolución de problemas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Resolución de problemas:</strong>Se enfrenta con gran dificultad a la resolución de problemas, dependiendo excesivamente de ayuda externa y mostrando bloqueo ante situaciones nuevas.";
            } elseif ($aciertos >= 3 && $aciertos <= 4 ) {
                return "<strong>Resolución de problemas:</strong>Resuelve problemas básicos de forma adecuada, aunque puede dudar en situaciones no familiares o complejas.";
            } else {
                return "<strong>Resolución de problemas:</strong>Destaca por su habilidad para analizar y resolver problemas de forma creativa y autónoma, incluso en situaciones complejas.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription11($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Retención de Información
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Retención de Información:</strong>Presenta serias dificultades para retener información a corto y largo plazo, lo que afecta su proceso de aprendizaje.";
            } elseif ($aciertos >= 3 && $aciertos <= 4 ) {
                return "<strong>Retención de Información:</strong>Retiene la información básica de forma adecuada, aunque puede tener problemas para recordar detalles o conceptos complejos.";
            } else {
                return "<strong>Retención de Información:</strong>Demuestra una excelente capacidad para retener y recordar información, aplicándola de forma consistente y precisa.";
            }
}
}
// Función que devuelve la descripción de la evaluación (dibujo) según el promedio de puntajes y el número de pregunta
function getEvaluationDescription12($puntaje_precision, $puntaje_colores, $puntaje_organizacion, $question) {
    // Calcular el promedio de los tres puntajes
    $score = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 6;
    // Redondeamos el promedio para trabajar con números enteros
    $score = round($score);

    switch($question) {
        case 1: // Para la evaluación de dibujo y pintura
            if ($score >= 0 && $score <= 2) {
                return "<strong>Dibujo y Pintura:</strong>Muestra un nivel muy bajo en dibujo y pintura; la representación visual es poco clara y carece de técnica, dificultando la expresión de ideas y emociones.";
            } elseif ($score >= 3 && $score <= 4) {
                return "<strong>Dibujo y Pintura:</strong>Su habilidad en dibujo y pintura es aceptable; logra expresar ideas básicas, aunque aún requiere mejorar en técnica y detalles.";
            } else {
                return "<strong>Dibujo y Pintura:</strong>Destaca por su creatividad y técnica en dibujo y pintura, transmitiendo ideas y emociones de forma impactante y precisa.";
            }
        default:
            return "";
    }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription13($puntaje_destreza, $puntaje_fuerza, $puntaje_coordinacion, $question) {
    $score = ($puntaje_destreza + $puntaje_fuerza + $puntaje_coordinacion) / 6;
    $score = round($score);
    switch($question) {
        case 1: // Escultura y Modelado
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Escultura y Modelado:</strong>Tiene dificultades notorias para esculpir y modelar, evidenciando poca destreza en la manipulación de materiales y en la creación de formas tridimensionales.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Escultura y Modelado:</strong>Su capacidad para esculpir y modelar es funcional, permitiéndole crear representaciones básicas, aunque con margen de mejora en precisión y detalle.";
            } else {
                return "<strong>Escultura y Modelado:</strong>Demuestra una gran habilidad en escultura y modelado, logrando representaciones tridimensionales precisas y expresivas con alta creatividad.";
            }
}
} 
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription14($puntaje_ritmo, $puntaje_tempo, $question) {
    $score = ($puntaje_ritmo + $puntaje_tempo) / 4;
    $score = round($score);
    switch($question) {
        case 1: // Música
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Música:</strong>Presenta dificultades para comprender y ejecutar conceptos musicales básicos, evidenciando problemas para interpretar ritmos y melodías.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Música:</strong>Tiene un desempeño aceptable en música, comprendiendo y ejecutando conceptos básicos, aunque con limitaciones en precisión y creatividad.";
            } else {
                return "<strong>Música:</strong>Demuestra un alto nivel musical, interpretando ritmos y melodías con precisión y creatividad, y mostrando una comprensión profunda de los conceptos musicales.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription15($puntaje_coordinacion, $puntaje_equilibrio, $puntaje_control_corporal, $puntaje_espontaneidad, $puntaje_creatividad, $question) {
    $score = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal + $puntaje_espontaneidad + $puntaje_creatividad) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Danza
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Danza y Expresión Corporal:</strong>Posee limitada coordinación y control corporal, con dificultades para expresarse a través de la danza y el movimiento.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Danza y Expresión Corporal:</strong>Muestra una coordinación y control corporal adecuados, permitiéndole participar en actividades de danza, aunque con margen de mejora en expresividad.";
            } else {
                return "<strong>Danza y Expresión Corporal:</strong>Destaca en la danza y expresión corporal, demostrando excelente coordinación, fluidez y capacidad para transmitir emociones a través del movimiento.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription16($puntaje_expresion, $puntaje_proyectar_voz, $puntaje_control_corporal, $puntaje_modular_tonos, $puntaje_articulacio, $question) {
    $score = ($puntaje_expresion + $puntaje_proyectar_voz + $puntaje_control_corporal + $puntaje_modular_tonos + $puntaje_articulacio) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Teatro
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Expresión Teatral:</strong>Presenta una expresión teatral limitada, con poca capacidad para interpretar y transmitir emociones de manera convincente.";
            } elseif ($score >= 3 && $score <= 4 ) {
                return "<strong>Expresión Teatral:</strong>Tiene un desempeño aceptable en expresión teatral, logrando interpretar roles de forma razonable, aunque con margen de mejora en profundidad emocional.";
            } else {
                return "<strong>Expresión Teatral:</strong>Se destaca en la expresión teatral, interpretando roles de manera convincente y emotiva, con una excelente capacidad para conectar con el público.";
            }
}
}

// Función que devuelve la descripción de la evaluación para aspectos académicos (preguntas 1 a 10)
function getEvaluationDescription17($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Participación en clases:</strong> Participa activamente, aportando ideas y fomentando el debate.";
            }
        case 2:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Atención:</strong> Mantiene una excelente atención, siguiendo las indicaciones sin distracciones.";
            }
        case 3:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Actitud ante los desafíos:</strong>Enfrenta los desafíos con entusiasmo y determinación.";
            }
        case 4:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Actitud para aprender:</strong> Está altamente motivado y se involucra de manera constante en su aprendizaje.";
            }
        case 5:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Compañerismo:</strong> Es ejemplar en compañerismo, fomenta la cooperación y apoya a sus compañeros.";
            }
        case 6:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Actitud ante las adversidades:</strong>Afronta las adversidades con fortaleza y aprende de los contratiempos.";
            }
        case 7:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Resolutividad:</strong>Destaca por su habilidad para encontrar soluciones creativas y actuar de forma autónoma.";
            }
        case 8:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Organización en sus actividades diarias:</strong>Es muy organizado, establece rutinas efectivas y maneja su tiempo de forma óptima.";
            }
        case 9:
            if ($score>= 4 && $score <= 5) {
                return " <strong>Resiliencia:</strong>Demuestra alta resiliencia, afrontando las dificultades con optimismo y aprendiendo de sus errores.";
            }
        case 10:
            if ($score>= 4 && $score <= 5) {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Es altamente responsable, cumpliendo puntualmente con sus tareas y demostrando un gran compromiso.";
            }
        default:
            return "";
    }
}

// Función que devuelve la descripción de la evaluación para aspectos académicos (preguntas 1 a 10)
function getEvaluationDescription17a($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Participación en clases:</strong>El estudiante apenas interviene en clase, muestra muy poca iniciativa y se mantiene al margen de las actividades grupales.";
            }
        case 2:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Atención:</strong>Presenta dificultades para mantener la atención y se distrae con facilidad.";
            }
        case 3:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante los desafíos:</strong>Evita enfrentar desafíos y muestra poco interés en superar obstáculos.";
            }
        case 4:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud para aprender:</strong> Presenta una actitud pasiva hacia el aprendizaje y muestra escaso interés.";
            }
        case 5:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Compañerismo:</strong>Tiene dificultades para trabajar en equipo y se aísla de sus compañeros.";
            }
        case 6:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante las adversidades:</strong>Se desanima fácilmente ante las adversidades, mostrando una respuesta negativa.";
            }
        case 7:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resolutividad:</strong> Depende en gran medida de la ayuda externa para resolver problemas.";
            }
        case 8:
            if ($score>= 0 && $score <= 2) {
                return " <strong>Organización en sus actividades diarias:</strong>Muestra una organización deficiente, lo que repercute negativamente en su rendimiento.";
            }
        case 9:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resiliencia:</strong>Presenta baja resiliencia y se desanima ante los fracasos.";
            }
        case 10:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Incumple frecuentemente sus deberes escolares, mostrando falta de compromiso.";
            }
        default:
            return "";
    }
}
// Función que devuelve la descripción de la evaluación para aspectos académicos (preguntas 1 a 10)
function getEvaluationDescription17b($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Participación en clases:</strong>Fomentar un ambiente emocional positivo que motive al estudiante a involucrarse activamente en el aula y contribuya a su bienestar integral.";
            }
        case 2:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Atención:</strong>Desarrollar la capacidad de concentrarse en las tareas y mantener el foco, reduciendo distracciones para un aprendizaje eficaz.";
            }
        case 3:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante los desafíos:Impulsar una actitud proactiva y resiliente que anime al estudiante a enfrentar y superar los retos que se presenten.";
            }
        case 4:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud para aprender:</strong> Estimular el interés y la curiosidad, promoviendo la búsqueda autónoma del conocimiento y el compromiso con el proceso educativo.";
            }
        case 5:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Compañerismo:</strong>Fomentar el trabajo en equipo y el apoyo mutuo, creando un entorno colaborativo que fortalezca las relaciones interpersonales.";
            }
        case 6:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante las adversidades:</strong>Incentivar la capacidad de enfrentar situaciones difíciles con determinación, aprendiendo de cada experiencia adversa.";
            }
        case 7:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resolutividad:</strong> Desarrollar habilidades para analizar problemas y encontrar soluciones creativas y efectivas, fortaleciendo el pensamiento crítico.";
            }
        case 8:
            if ($score>= 0 && $score <= 2) {
                return " <strong>Organización en sus actividades diarias:</strong>Promover la planificación y estructuración de tareas, ayudando al estudiante a gestionar su tiempo y actividades de forma ordenada.";
            }
        case 9:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resiliencia:</strong>Fortalecer la capacidad para recuperarse rápidamente de los fracasos y adaptarse a los cambios, consolidando la autoconfianza.";
            }
        case 10:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Impulsar el compromiso y la disciplina en el cumplimiento de las obligaciones académicas, fomentando la puntualidad y el autocontrol.";
            }
        default:
            return "";
    }
}
// Función que devuelve la descripción de la evaluación para aspectos académicos (preguntas 1 a 10)
function getEvaluationDescription17c($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Participación en clases:</strong>Se fomentará una participación activa y comprometida en el aula, incentivando al estudiante a formular preguntas y compartir sus ideas, lo que enriquece el proceso de aprendizaje y fortalece la interacción con sus compañeros y docentes.";
            }
        case 2:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Atención:</strong>Se implementarán estrategias específicas para mejorar la capacidad de atención durante las actividades académicas, utilizando técnicas de focalización y apoyos visuales y auditivos que faciliten el seguimiento de las explicaciones y tareas.";
            }
        case 3:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante los desafíos:Se promoverá una actitud positiva y proactiva frente a los desafíos académicos, alentando al estudiante a ver las dificultades como oportunidades para aprender y crecer, mediante el establecimiento de metas alcanzables y el reconocimiento de sus esfuerzos.";
            }
        case 4:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud para aprender:</strong> Se incentivará una mentalidad abierta y receptiva al aprendizaje, motivando al estudiante a explorar nuevos conocimientos con curiosidad y a participar activamente en las actividades propuestas, lo que fortalecerá su proceso formativo.";
            }
        case 5:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Compañerismo:</strong>Se trabajará el fortalecimiento de las relaciones interpersonales, promoviendo un ambiente de respeto y colaboración entre compañeros, lo que facilitará el aprendizaje cooperativo y la integración social dentro del grupo.";
            }
        case 6:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Actitud ante las adversidades:</strong>Se impulsará la capacidad de enfrentar situaciones adversas con serenidad y determinación, apoyando al estudiante en el desarrollo de estrategias para gestionar el estrés y las frustraciones que puedan surgir en el ámbito escolar.
";
            }
        case 7:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resolutividad:</strong>Se desarrollarán habilidades de resolución de problemas, orientando al estudiante a identificar situaciones conflictivas y aplicar de manera autónoma estrategias efectivas para solucionarlas, favoreciendo así su autonomía y confianza.";
            }
        case 8:
            if ($score>= 0 && $score <= 2) {
                return " <strong>Organización en sus actividades diarias:</strong>Se promoverá la planificación y estructuración de las actividades diarias, facilitando el uso de agendas y herramientas de gestión del tiempo que permitan al estudiante organizar sus tareas y responsabilidades de forma eficaz.";
            }
        case 9:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Resiliencia:</strong>Se fortalecerá la resiliencia mediante actividades y dinámicas que permitan al estudiante aprender a recuperarse de las dificultades, fomentando la reflexión sobre sus experiencias y la adaptación ante los cambios.";
            }
        case 10:
            if ($score>= 0 && $score <= 2) {
                return "<strong>Responsabilidad con sus deberes escolares:</strong>Se reforzará el compromiso y la responsabilidad en el cumplimiento de los deberes escolares, estableciendo rutinas claras y recordatorios que permitan al estudiante consolidar hábitos de estudio consistentes y organizados.";
            }
        default:
            return "";
    }
}

// Función que devuelve un comentario para bienestar (question 1) y motivación (question 2) según la escala
function getEvaluationDescription18($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Bienestar
            if ($score>= 4) {
                return "<strong>Bienestar:</strong>Se percibe altamente satisfecho consigo mismo.";
            }
        case 2: // Motivación
            if ($score>= 4) {
                return "<strong>Motivación:</strong>También se percibe altamente motivado.";
            }
        default:
            return "";
    }
}
// Función que devuelve un comentario para bienestar (question 1) y motivación (question 2) según la escala
function getEvaluationDescription18a($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Bienestar
            if ($score <= 2) {
                return "<strong>Bienestar:</strong>Manifiesta un nivel bajo de satisfacción personal.";
            }
        case 2: // Motivación
            if ($score <= 2) {
                return "<strong>Motivación:</strong>También manifiesta niveles bajos de motivación.";
            }
        default:
            return "";
    }
}
// Función que devuelve un comentario para bienestar (question 1) y motivación (question 2) según la escala
function getEvaluationDescription18b($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Bienestar
            if ($score <= 2) {
                return "<strong>Bienestar:</strong>Fomentar un equilibrio integral que potencie el bienestar emocional, físico y social del estudiante, fortaleciendo su autoestima y resiliencia.";
            }
        case 2: // Motivación
            if ($score <= 2) {
                return "<strong>Motivación:</strong>Estimular el interés y compromiso en el proceso de aprendizaje, impulsando una actitud proactiva y perseverante ante los desafíos.";
            }
        default:
            return "";
    }
}
// Función que devuelve un comentario para bienestar (question 1) y motivación (question 2) según la escala
function getEvaluationDescription18c($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Bienestar
            if ($score <= 2) {
                return "<strong>Bienestar:</strong>Se velará por el bienestar integral del estudiante, promoviendo un ambiente seguro y de apoyo que atienda tanto sus necesidades emocionales como académicas, garantizando que se sienta valorado y respaldado en su proceso de aprendizaje.";
            }
        case 2: // Motivación
            if ($score <= 2) {
                return "<strong>Motivación:</strong>Se implementarán estrategias motivacionales que estimulen el interés por aprender, reconociendo los logros alcanzados y ofreciendo retroalimentación positiva que refuerce la autoestima y el compromiso con el proceso educativo.";
            }
        default:
            return "";
    }
}

// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription19($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:// Comprensión Lectora
            if ($score == 3 ) {
                return "<strong>Comprensión Lectora:</strong>Demuestra una excelente capacidad de comprensión lectora.";
            } else {
                return "";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription19a($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:// Comprensión Lectora
            if ($score <= 1 ) {
                return "<strong>Comprensión Lectora:</strong>Presenta dificultades significativas para comprender textos.";
            }
}
}

// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription19b($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:// Comprensión Lectora
            if ($score <= 1 ) {
                return "<strong>Comprensión Lectora:</strong>Desarrollar la capacidad de interpretar, analizar y extraer información relevante de los textos, facilitando la comprensión crítica.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription19c($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1:// Comprensión Lectora
            if ($score <= 1 ) {
                return "<strong>Comprensión Lectora:</strong>Se potenciará la comprensión lectora a través de actividades de lectura guiada, análisis de textos y discusiones orientadas a interpretar y reflexionar sobre el contenido, fortaleciendo el pensamiento crítico y la capacidad interpretativa.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription20($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Escritura
            if ($score>= 4 && $score <= 5 ) {
                return "<strong>Escritura:</strong>Escribe con gran claridad y coherencia, utilizando un lenguaje preciso y estructurando sus ideas de forma lógica y organizada.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription20a($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Escritura
            if ($score  >= 0 && $score <= 2 ) {
                return " <strong>Escritura:</strong>Tiene serias dificultades para estructurar sus ideas de forma coherente y clara; se observan errores gramaticales y ortográficos frecuentes.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription20b($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Escritura
            if ($score  >= 0 && $score <= 2 ) {
                return " <strong>Escritura:</strong> Mejorar la habilidad de expresar ideas de forma clara y coherente, fortaleciendo la redacción y precisión en el uso del lenguaje.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription20c($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Escritura
            if ($score  >= 0 && $score <= 2 ) {
                return " <strong>Escritura:</strong> Se trabajará el desarrollo de habilidades de escritura, fomentando la expresión clara y coherente de ideas mediante prácticas de redacción, corrección y retroalimentación que permitan mejorar la estructura y el estilo en los textos.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription21($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // Matemáticas Básicas
            if ($score>= 4 && $score <= 5) {
                return "<strong>Matemáticas Básicas:</strong>Demuestra una destacada habilidad para resolver problemas matemáticos básicos, con rapidez y precisión.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription21a($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // matemáticas básicas
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Matemáticas Básicas:</strong>Muestra dificultades considerables en la resolución de operaciones básicas y en la aplicación de conceptos matemáticos elementales.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription21b($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // matemáticas básicas
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Matemáticas Básicas:</strong>Consolidar conceptos fundamentales y técnicas de resolución de problemas, permitiendo el razonamiento lógico en situaciones cotidianas.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription21c($score, $question) {
    $score = (int)$score;
    switch($question) {
        case 1: // matemáticas básicas
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Matemáticas Básicas:</strong>Se reforzarán los conceptos fundamentales de matemáticas básicas, utilizando métodos visuales y prácticos que faciliten la comprensión de operaciones y conceptos, adaptando la enseñanza a las necesidades específicas del estudiante.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription22($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Memoria
            if ($aciertos >= 4 && $aciertos <= 5 ) {
                return "<strong>Memoria:</strong>Demuestra una excelente retención y recuperación de información.";
            }
}
}
function getEvaluationDescription22a($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // memoria
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Memoria:</strong>Muestra dificultades considerables para retener y recuperar información.";
            }
}
}
function getEvaluationDescription22b($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // memoria
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Memoria:</strong>Potenciar la capacidad para retener y recuperar información, favoreciendo el aprendizaje sostenido y la aplicación de conocimientos.";
            }
}
}
function getEvaluationDescription22c($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // memoria
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Memoria:</strong>Se implementarán técnicas y ejercicios orientados a fortalecer la memoria, tales como actividades mnemotécnicas y resúmenes, con el objetivo de mejorar la retención y recuperación de información de forma sostenida.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription23($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Funciones Ejecutivas
            if ($aciertos >= 4 && $aciertos <= 5) {
                return "<strong>Funciones Ejecutivas:</strong>Destaca por una excelente capacidad de planificación, organización y toma de decisiones.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription23a($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // funciones ejecutivas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Funciones Ejecutivas:</strong>Sus funciones ejecutivas son limitadas; muestra dificultades en la planificación, organización y toma de decisiones.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription23b($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // funciones ejecutivas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Funciones Ejecutivas:</strong>Optimizar la planificación, organización y toma de decisiones, facilitando la gestión autónoma de tareas y problemas complejos.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription23c($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // funciones ejecutivas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Funciones Ejecutivas:</strong>Se desarrollarán las funciones ejecutivas mediante actividades que estimulen la planificación, la organización, la toma de decisiones y la autorregulación, facilitando el manejo de la información y la resolución de problemas en el entorno académico.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription24($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Habilidades Visoespaciales
            if ($aciertos >= 4 && $aciertos <= 5) {
                return "<strong>Habilidades Visoespaciales:</strong>Demuestra una aguda percepción visoespacial.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription24a($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // habilidades Visoespaciales
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Habilidades Visoespaciales:</strong>Tiene dificultades para percibir y manipular la información visual.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription24b($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // habilidades Visoespaciales
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Habilidades Visoespaciales:</strong>Desarrollar la destreza para interpretar y organizar la información visual, mejorando la coordinación ojo-mano y la percepción espacial.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription24c($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // habilidades Visoespaciales
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Habilidades Visoespaciales:</strong>Se potenciarán las habilidades visoespaciales a través de ejercicios que estimulen la percepción y el reconocimiento de formas, patrones y relaciones espaciales, contribuyendo al desarrollo de destrezas visuales y motoras.";
            }
        }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription25($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Atención Concentración
            if ($aciertos == 15  ) {
                return "<strong>Atención Concentración:</strong>Mantiene una excelente concentración en actividades en clase.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription25a($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Atención concentración
            if ($aciertos == 2  ) {
                return "<strong>Atención Concentración:</strong>Presenta marcada distracción y dificultad para mantener la atención en clase.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription25b($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Atención concentración
            if ($aciertos == 2  ) {
                return "<strong>Atención Concentración:</strong>Incrementar la capacidad de mantener el foco en actividades específicas, reduciendo distracciones y mejorando el rendimiento académico.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription25c($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Atención concentración
            if ($aciertos == 2  ) {
                return "<strong>Atención Concentración:</strong>Se reforzará la atención y la concentración mediante técnicas que permitan mantener el enfoque durante períodos prolongados, minimizando distracciones y promoviendo la constancia en la realización de las actividades escolares.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription26($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Resolución de Problemas
            if ($aciertos >= 4 && $aciertos <= 5) {
                return "<strong>Resolución de Problemas:</strong>Destaca por su habilidad para analizar y resolver problemas de forma creativa y autónoma.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription26a($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Resolución de problemas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Resolución de Problemas:</strong>Se enfrenta con gran dificultad a la resolución de problemas.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription26b($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Resolución de problemas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Resolución de Problemas:</strong>Fomentar la identificación y análisis de situaciones problemáticas para desarrollar estrategias creativas y efectivas de solución.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription26c($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Resolución de problemas
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Resolución de Problemas:</strong>Se estimulará la capacidad para analizar y resolver problemas mediante la identificación de alternativas y la aplicación de estrategias lógicas, favoreciendo el pensamiento crítico y la autonomía en la búsqueda de soluciones.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription27($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Retención de Información
            if ($aciertos >= 4 && $aciertos <= 5) {
                return "<strong>Retención de Información:</strong>Demuestra una excelente capacidad para retener y recordar información.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription27a($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Retención de Información
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Retención de Información:</strong>Presenta serias dificultades para retener información a corto y largo plazo.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription27b($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Retención de Información
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Retención de Información:</strong>Mejorar la habilidad para almacenar y recordar datos y conceptos, apoyando un aprendizaje duradero y significativo.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription27c($aciertos, $question) {
    $aciertos = (int)$aciertos;
    switch($question) {
        case 1: // Retención de Información
            if ($aciertos >= 0 && $aciertos <= 2 ) {
                return "<strong>Retención de Información:</strong>Se implementarán prácticas de estudio que faciliten la retención de información, como la elaboración de resúmenes, mapas conceptuales y el uso de técnicas de repetición, asegurando un aprendizaje profundo y duradero.";
            }
}
}
// Función que devuelve la descripción de la evaluación (dibujo) según el promedio de puntajes y el número de pregunta
function getEvaluationDescription28($puntaje_precision, $puntaje_colores, $puntaje_organizacion, $question) {
    // Calcular el promedio de los tres puntajes
    $score = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 6;
    // Redondeamos el promedio para trabajar con números enteros
    $score = round($score);

    switch($question) {
        case 1: // Para la evaluación de dibujo y pintura
            if ($score >= 4 && $score <= 5) {
                return "<strong>Dibujo y Pintura:</strong>Destaca por su creatividad y técnica en dibujo y pintura.";
            }
    }
}
// Función que devuelve la descripción de la evaluación (dibujo) según el promedio de puntajes y el número de pregunta
function getEvaluationDescription28a($puntaje_precision, $puntaje_colores, $puntaje_organizacion, $question) {
    // Calcular el promedio de los tres puntajes
    $score = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 6;
    // Redondeamos el promedio para trabajar con números enteros
    $score = round($score);

    switch($question) {
        case 1: // Para la evaluación de dibujo y pintura
            if ($score >= 0 && $score <= 2) {
                return "<strong>Dibujo y Pintura:</strong>Muestra un nivel muy bajo en dibujo y pintura.";
            }
    }
}
// Función que devuelve la descripción de la evaluación (dibujo) según el promedio de puntajes y el número de pregunta
function getEvaluationDescription28b($puntaje_precision, $puntaje_colores, $puntaje_organizacion, $question) {
    // Calcular el promedio de los tres puntajes
    $score = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 6;
    // Redondeamos el promedio para trabajar con números enteros
    $score = round($score);

    switch($question) {
        case 1: // Para la evaluación de dibujo y pintura
            if ($score >= 0 && $score <= 2) {
                return "<strong>Dibujo y Pintura:</strong>Estimular la creatividad y técnica en la representación visual, permitiendo la expresión artística y el desarrollo de habilidades manuales.";
            }
    }
}
// Función que devuelve la descripción de la evaluación (dibujo) según el promedio de puntajes y el número de pregunta
function getEvaluationDescription28c($puntaje_precision, $puntaje_colores, $puntaje_organizacion, $question) {
    // Calcular el promedio de los tres puntajes
    $score = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 6;
    // Redondeamos el promedio para trabajar con números enteros
    $score = round($score);

    switch($question) {
        case 1: // Para la evaluación de dibujo y pintura
            if ($score >= 0 && $score <= 2) {
                return "<strong>Dibujo y Pintura:</strong>Se promoverá la expresión artística en dibujo y pintura, proporcionando actividades creativas que permitan al estudiante desarrollar sus habilidades visuales y expresarse de manera estética, integrando estos aprendizajes en su proceso académico.
";
            }
    }
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription29($puntaje_destreza, $puntaje_fuerza, $puntaje_coordinacion, $question) {
    $score = ($puntaje_destreza + $puntaje_fuerza + $puntaje_coordinacion) / 6;
    $score = round($score);
    switch($question) {
        case 1: // Escultura y Modelado
            if ($score >= 4 && $score <= 5) {
                return "<strong>Escultura y Modelado:</strong>Demuestra una gran habilidad en escultura y modelado.";
            }
}
} 
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription29a($puntaje_destreza, $puntaje_fuerza, $puntaje_coordinacion, $question) {
    $score = ($puntaje_destreza + $puntaje_fuerza + $puntaje_coordinacion) / 6;
    $score = round($score);
    switch($question) {
        case 1: // Escultura y Modelado
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Escultura y Modelado:</strong>Tiene dificultades notorias para esculpir y modelar.";
            }
}
} 
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription29b($puntaje_destreza, $puntaje_fuerza, $puntaje_coordinacion, $question) {
    $score = ($puntaje_destreza + $puntaje_fuerza + $puntaje_coordinacion) / 6;
    $score = round($score);
    switch($question) {
        case 1: // Escultura y Modelado
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Escultura y Modelado:</strong>Promover la capacidad para crear formas tridimensionales con precisión, desarrollando destrezas en el manejo de materiales artísticos.";
            }
}
} 
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription29c($puntaje_destreza, $puntaje_fuerza, $puntaje_coordinacion, $question) {
    $score = ($puntaje_destreza + $puntaje_fuerza + $puntaje_coordinacion) / 6;
    $score = round($score);
    switch($question) {
        case 1: // Escultura y Modelado
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Escultura y Modelado:</strong>Se incentivará la exploración de la expresión tridimensional mediante actividades de escultura y modelado, permitiendo al estudiante materializar ideas y conceptos de forma tangible, enriqueciendo su experiencia artística.";
            }
}
} 
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription30($puntaje_ritmo, $puntaje_tempo, $question) {
    $score = ($puntaje_ritmo + $puntaje_tempo) / 4;
    $score = round($score);
    switch($question) {
        case 1: // Música
            if ($score >= 4 && $score <= 5) {
                return "<strong>Música:</strong>Demuestra un alto nivel musical.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription30a($puntaje_ritmo, $puntaje_tempo, $question) {
    $score = ($puntaje_ritmo + $puntaje_tempo) / 4;
    $score = round($score);
    switch($question) {
        case 1: // Música
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Música:</strong>Presenta dificultades para comprender y ejecutar conceptos musicales básicos.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription30b($puntaje_ritmo, $puntaje_tempo, $question) {
    $score = ($puntaje_ritmo + $puntaje_tempo) / 4;
    $score = round($score);
    switch($question) {
        case 1: // Música
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Música:</strong>Fomentar la apreciación y práctica musical, desarrollando el sentido del ritmo, la melodía y la armonía como herramientas de expresión creativa.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription30c($puntaje_ritmo, $puntaje_tempo, $question) {
    $score = ($puntaje_ritmo + $puntaje_tempo) / 4;
    $score = round($score);
    switch($question) {
        case 1: // Música
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Música:</strong>Se fomentará el desarrollo musical a través de actividades que integren la apreciación, interpretación y creación musical, ofreciendo un espacio para la expresión sonora y el enriquecimiento cultural dentro del currículo.";
            }
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription31($puntaje_coordinacion, $puntaje_equilibrio, $puntaje_control_corporal, $puntaje_espontaneidad, $puntaje_creatividad, $question) {
    $score = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal + $puntaje_espontaneidad + $puntaje_creatividad) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Danza
            if ($score >= 4 && $score <= 5) {
                return "<strong>Danza:</strong>Destaca en la danza y expresión corporal.";
            }  
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription31a($puntaje_coordinacion, $puntaje_equilibrio, $puntaje_control_corporal, $puntaje_espontaneidad, $puntaje_creatividad, $question) {
    $score = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal + $puntaje_espontaneidad + $puntaje_creatividad) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Danza
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Danza:</strong>Presenta una limitada habilidad en danza y expresión corporal.";
            }  
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription31b($puntaje_coordinacion, $puntaje_equilibrio, $puntaje_control_corporal, $puntaje_espontaneidad, $puntaje_creatividad, $question) {
    $score = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal + $puntaje_espontaneidad + $puntaje_creatividad) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Danza
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Danza y Expresión Corporal:</strong>Impulsar la coordinación y la expresión a través del movimiento, fortaleciendo la conexión emocional y la comunicación no verbal.";
            }  
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription31c($puntaje_coordinacion, $puntaje_equilibrio, $puntaje_control_corporal, $puntaje_espontaneidad, $puntaje_creatividad, $question) {
    $score = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal + $puntaje_espontaneidad + $puntaje_creatividad) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Danza
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Danza y Expresión Corporal:</strong>Se promoverá la danza y la expresión corporal como medios para desarrollar la coordinación motriz, la comunicación no verbal y la creatividad, mediante actividades que integren el movimiento y la expresión física de forma respetuosa y lúdica.";
            }  
}
}
// Función que devuelve la descripción de la evaluación según el puntaje y el número de pregunta
function getEvaluationDescription32($puntaje_expresion, $puntaje_proyectar_voz, $puntaje_control_corporal, $puntaje_modular_tonos, $puntaje_articulacio, $question) {
    $score = ($puntaje_expresion + $puntaje_proyectar_voz + $puntaje_control_corporal + $puntaje_modular_tonos + $puntaje_articulacio) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Teatro
            if ($score >= 4 && $score <= 5) {
                return "<strong>Teatro:</strong>Se destaca en la expresión teatral.";
            }
        }
    }
function getEvaluationDescription32a($puntaje_expresion, $puntaje_proyectar_voz, $puntaje_control_corporal, $puntaje_modular_tonos, $puntaje_articulacio, $question) {
    $score = ($puntaje_expresion + $puntaje_proyectar_voz + $puntaje_control_corporal + $puntaje_modular_tonos + $puntaje_articulacio) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Teatro
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Teatro:</strong>Presenta una expresión teatral limitada";
            }
}
}
function getEvaluationDescription32b($puntaje_expresion, $puntaje_proyectar_voz, $puntaje_control_corporal, $puntaje_modular_tonos, $puntaje_articulacio, $question) {
    $score = ($puntaje_expresion + $puntaje_proyectar_voz + $puntaje_control_corporal + $puntaje_modular_tonos + $puntaje_articulacio) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Teatro
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Expresión Teatral:</strong> Desarrollar la habilidad para interpretar y transmitir emociones en escena, mejorando la comunicación y la creatividad en el ámbito dramático.";
            }
}
}
function getEvaluationDescription32c($puntaje_expresion, $puntaje_proyectar_voz, $puntaje_control_corporal, $puntaje_modular_tonos, $puntaje_articulacio, $question) {
    $score = ($puntaje_expresion + $puntaje_proyectar_voz + $puntaje_control_corporal + $puntaje_modular_tonos + $puntaje_articulacio) / 10;
    $score = round($score);
    switch($question) {
        case 1: // Teatro
            if ($score >= 0 && $score <= 2 ) {
                return "<strong>Expresión Teatral:</strong> Se fortalecerá la expresión teatral, incentivando la participación en dramatizaciones y actividades escénicas que potencien la comunicación, la empatía y la autoexpresión, contribuyendo al desarrollo integral del estudiante.
";
            }
}
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Plan de Intervención</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Librerías para la exportación a PDF -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
  <style>
    body { font-family: Arial, sans-serif; margin: 0; padding: 20px; }
    .container { max-width: 800px; margin: auto; }
    /* Pestañas */
    .tabs { display: flex; border-bottom: 1px solid #ccc; margin-bottom: 20px; }
    .tab { padding: 10px 20px; cursor: pointer; border: 1px solid #ccc; border-bottom: none; }
    .tab.active { background-color: #f0f0f0; font-weight: bold; }
    .tab-content { display: none; padding: 20px; border: 1px solid #ccc; }
    .tab-content.active { display: block; }
    .btn { padding: 8px 16px; margin: 5px; cursor: pointer; background-color: #007BFF; color: #fff; border: none; border-radius: 4px; }
    .btn:hover { background-color: #0056b3; }
    input[type="text"], input[type="date"], textarea { width: 100%; padding: 8px; margin: 5px 0; }
    label { font-weight: bold; margin-top: 10px; display: block; }
    .button-container { text-align: right; margin-bottom: 10px; }
    .beneficiary-photo { max-width: 150px; }
    .section { margin-bottom: 20px; }
    .section ul { list-style-type: disc; margin-left: 20px; }
    /* Ocultar elementos en impresión */
    @media print {
      .no-print { display: none; }
    }
  </style>
  <script>
    // Función para activar pestañas (solo visualización en pantalla)
    function openTab(tabName) {
      var contents = document.getElementsByClassName("tab-content");
      var tabs = document.getElementsByClassName("tab");
      for (var i = 0; i < contents.length; i++) {
        contents[i].classList.remove("active");
      }
      for (var i = 0; i < tabs.length; i++) {
        tabs[i].classList.remove("active");
      }
      document.getElementById(tabName).classList.add("active");
      var tabButton = document.getElementById("tab-" + tabName);
      if(tabButton) {
        tabButton.classList.add("active");
      }
    }
    window.onload = function() {
      openTab('info');
    };

    // Función que genera el HTML completo para impresión/PDF con todas las secciones
    function getPrintHTML() {
      // Se crea el encabezado personalizado con escudo, título y fotografía
      var headerHTML = '<div style="display:flex; justify-content: space-between; align-items: center; margin-bottom:20px;">';
      headerHTML += '<div><img src="uploads/fotos/escudo.jpg" alt="Escudo Institucional" style="max-width:100px;"></div>';
      headerHTML += '<div style="text-align:center;">';
      headerHTML += '<h1 style="font-size:28px; color:#007BFF; margin:0;">Fundación Proyecto 21 centro especializado Andres Felipe Melendes Forero</h1>';
      headerHTML += '<h2 style="font-size:24px; color:#333; margin:0;">Sistema de Gestión de Beneficiarios (Plan de Intervención)</h2>';
      headerHTML += '<p style="font-size:18px; color:#555; margin:0;">2025</p>';
      headerHTML += '</div>';
      headerHTML += '</div>';

      // Lista de secciones (se omite el título para la sección 'info')
      var sections = [
        { id: 'info', title: '' },
        { id: 'vis', title: 'Visión Integral' },
        { id: 'obj', title: 'Objetivos' },
        { id: 'estrat', title: 'Estrategias de Intervención' },
        { id: 'seg', title: 'Seguimiento' }
      ];
      var fullContent = '';
      sections.forEach(function(section) {
        var elem = document.getElementById(section.id);
        if (elem) {
          var clone = elem.cloneNode(true);
          // Eliminar botones u otros elementos interactivos
          var botones = clone.querySelectorAll('button');
          botones.forEach(function(btn) { btn.remove(); });
          if (section.title) {
            fullContent += '<h1 style="color:#333; font-size:28px; margin-bottom:10px;">' + section.title + '</h1>';
          }
          fullContent += clone.innerHTML;
          fullContent += '<hr style="border:0; border-top:1px solid #ddd; margin:20px 0;">';
        }
      });
      
      // Construir el contenedor completo con estilos embebidos
      var fullHTML = '<div id="PrintContainer" style="background-color:#fff; padding:30px; margin:auto; border:1px solid #ddd; border-radius:8px; max-width:800px;">';
      fullHTML += '<style>';
      fullHTML += 'body { font-family:"Helvetica Neue", Helvetica, Arial, sans-serif; margin:0; padding:20px; background-color:#f8f8f8; }';
      fullHTML += 'h1 { color:#333; font-size:28px; margin-bottom:10px; }';
      fullHTML += 'h2 { font-size:24px; color:#666; margin-bottom:8px; }';
      fullHTML += 'p, ul, li { font-size:16px; line-height:1.8; color:#444; }';
      fullHTML += 'hr { border:0; border-top:1px solid #ddd; margin:20px 0; }';
      fullHTML += '</style>';
      fullHTML += headerHTML + fullContent;
      fullHTML += '</div>';
      return fullHTML;
    }

    // Función para abrir ventana de impresión con el documento completo
    function printFull() {
      var printHTML = getPrintHTML();
      var printWindow = window.open('', '', 'height=800,width=800');
      printWindow.document.write('<html><head><title>Impresión Plan de Intervención</title>');
      printWindow.document.write('<style>');
      printWindow.document.write('body { font-family:"Helvetica Neue", Helvetica, Arial, sans-serif; padding:20px; background-color:#f8f8f8; }');
      printWindow.document.write('#PrintContainer { background-color:#fff; padding:30px; margin:auto; border:1px solid #ddd; border-radius:8px; max-width:800px; }');
      printWindow.document.write('h1 { color:#333; font-size:28px; margin-bottom:10px; }');
      printWindow.document.write('h2 { font-size:24px; color:#666; margin-bottom:8px; }');
      printWindow.document.write('p, ul, li { font-size:16px; line-height:1.8; color:#444; }');
      printWindow.document.write('hr { border:0; border-top:1px solid #ddd; margin:20px 0; }');
      printWindow.document.write('</style>');
      printWindow.document.write('</head><body>');
      printWindow.document.write(printHTML);
      printWindow.document.write('</body></html>');
      printWindow.document.close();
      printWindow.focus();
      printWindow.print();
    }

    // Función para exportar a PDF el documento completo
function exportFullPDF() {
    var printHTML = getPrintHTML();
    var tempContainer = document.createElement('div');
    tempContainer.style.position = "absolute";
    tempContainer.style.left = "-9999px";
    tempContainer.innerHTML = printHTML;
    document.body.appendChild(tempContainer);
    
    html2canvas(tempContainer, { scale: 2 }).then(function(canvas) {
      var imgData = canvas.toDataURL('image/png');
      const { jsPDF } = window.jspdf;
      var pdf = new jsPDF('p', 'mm', 'a4');
      var pdfWidth = pdf.internal.pageSize.getWidth();
      var pdfHeight = pdf.internal.pageSize.getHeight();
      
      // Definimos el margen inferior deseado en milímetros:
      var marginBottom = 35; // 35 mm de margen inferior
      // Altura disponible para el contenido en cada página:
      var usablePageHeight = pdfHeight - marginBottom;
      
      // Escalar la imagen a ocupar el ancho de la página:
      var imgWidth = pdfWidth;
      var imgHeight = canvas.height * pdfWidth / canvas.width;
      
      var heightLeft = imgHeight;
      var position = 0;
      
      // Se agrega la primera parte de la imagen, que ocupará usablePageHeight
      pdf.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
      heightLeft -= usablePageHeight;
      
      while (heightLeft > 0) {
        position -= usablePageHeight;
        pdf.addPage();
        pdf.addImage(imgData, 'PNG', 0, position, imgWidth, imgHeight);
        heightLeft -= usablePageHeight;
      }
      
      pdf.save('Plan_de_Intervencion.pdf');
      document.body.removeChild(tempContainer);
    });
  }
  </script>
</head>
<body>
  <!-- Botones de acción (no se incluyen en impresión) -->
  <div class="no-print">
    <button onclick="printFull()" class="btn">Imprimir Documento</button>
    <button onclick="exportFullPDF()" class="btn">Exportar a PDF</button>
  </div>
  
  <h1>Plan de Intervención</h1>
  <div class="tabs">
    <div class="tab" id="tab-info" onclick="openTab('info')">INFORMACIÓN GENERAL</div>

    <div class="tab" id="tab-vis" onclick="openTab('vis')">VISIÓN INTEGRAL</div>
    <div class="tab" id="tab-obj" onclick="openTab('obj')">OBJETIVOS</div>
    <div class="tab" id="tab-estrat" onclick="openTab('estrat')">ESTRATEGIAS DE INTERVENCIÓN</div>
    <!--div class="tab" id="tab-seg" onclick="openTab('seg')">SEGUIMIENTO</div-->
  </div>
    <!-- Pestaña de Información General -->
    <div id="info" class="tab-content">
        <h2>Información General</h2>
        <img class="beneficiary-photo" src="uploads/fotos/<?php echo htmlspecialchars($beneficiario['fotografia']); ?>" alt="Foto de <?php echo htmlspecialchars($beneficiario['nombre_completo']); ?>" width="100">
        <form action="update.php" method="POST">
            <input type="hidden" name="id" value="<?php echo $beneficiario['id']; ?>">
            <label>Nombre Completo:</label>
            <input type="text" name="nombre_completo" value="<?php echo htmlspecialchars($beneficiario['nombre_completo']); ?>" required>
            <label>Documento de Identidad:</label>
            <input type="text" name="documento_identidad" value="<?php echo htmlspecialchars($beneficiario['documento_identidad']); ?>" required>
            <label>Fecha de Nacimiento:</label>
            <input type="Date" name="fecha_nacimiento" value="<?php echo htmlspecialchars($beneficiario['fecha_nacimiento']); ?>" required>
            <label>Correo Electrónico:</label>
            <input type="text" name="correo_electronico" value="<?php echo htmlspecialchars($beneficiario['correo_electronico']); ?>">
            <label>Acudiente:</label>
            <input type="text" name="acudiente" value="<?php echo htmlspecialchars($beneficiario['acudiente']); ?>">
            <label>Institución Patrocinadora:</label>
            <input type="text" name="institucion_patrocinadora" value="<?php echo htmlspecialchars($beneficiario['institucion_patrocinadora']); ?>">
            <label>Grupo:</label>
            <input type="text" name="grupo" value="<?php echo htmlspecialchars($beneficiario['grupo']); ?>">
            <label>Programa:</label>
            <input type="text" name="programa" value="<?php echo htmlspecialchars($beneficiario['programa']); ?>">
            <label>Modalidad:</label>
            <input type="text" name="modalidad" value="<?php echo htmlspecialchars($beneficiario['modalidad']); ?>">
            <label>Sede:</label>
            <input type="text" name="sede" value="<?php echo htmlspecialchars($beneficiario['sede']); ?>">
            <label>Diagnosis:</label>
            <input type="text" name="diagnosis" value="<?php echo htmlspecialchars($beneficiario['diagnosis']); ?>">
            <button type="submit" class="btn">Actualizar Información</button>
        </form>
    </div>

    <!-- Pestaña de Visión Integral -->
    <div id="vis" class="tab-content">
<h2>1.1 Características Generales</h2>
<!-- Contenido original de Visión Integral -->
<p>Esta sección presenta una visión global del desempeño y las competencias del estudiante, integrando diversos aspectos de su formación.</p>
<div class="section">
    <strong><?php echo htmlspecialchars($beneficiario['nombre_completo']); ?></strong> con diagnóstico: 
    <strong><?php echo htmlspecialchars($beneficiario['diagnosis']); ?></strong>, se encuentra matriculado en el programa 
    <strong><?php echo htmlspecialchars($beneficiario['programa']); ?></strong>,
   <ul>
                <p> 
    <?php if ($cuestionario): ?>
        <?php echo getEvaluationDescription2($cuestionario['bienestar_post'], 1); ?>
    </p>
    <p> 
        <?php echo getEvaluationDescription2($cuestionario['motivacion_post'], 2); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($lectura): ?>
        <?php echo getEvaluationDescription3($lectura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escritura): ?>
        <?php echo getEvaluationDescription4($escritura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($matematicas): ?>
        <?php echo getEvaluationDescription5($matematicas['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($evaluacion): ?>
        <?php echo getEvaluationDescription($evaluacion['pregunta1'], 1); ?>
        </p>
    <p>
        <?php echo getEvaluationDescription($evaluacion['pregunta4'], 4); ?>
        </p>
    <p>
        <?php echo getEvaluationDescription($evaluacion['pregunta10'], 10); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <br>
    <h2>1.2 Habilidades Cognitivas Artísticas y del Desarrollo</h2>
    <p>
    <?php if ($memoria): ?>
        <?php echo getEvaluationDescription6($memoria['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($funciones): ?>
        <?php echo getEvaluationDescription7($funciones['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($visoespacial): ?>
        <?php echo getEvaluationDescription8($visoespacial['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($atencion): ?>
        <?php echo getEvaluationDescription9($atencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($problemas): ?>
        <?php echo getEvaluationDescription10($problemas['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($retencion): ?>
        <?php echo getEvaluationDescription11($retencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($dibujo): ?>
        <?php echo getEvaluationDescription12($dibujo['puntaje_precision'], $dibujo['puntaje_colores'], $dibujo['puntaje_organizacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escultura): ?>
        <?php echo getEvaluationDescription13($escultura['puntaje_destreza'], $escultura['puntaje_fuerza'], $escultura['puntaje_coordinacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($musica): ?>
        <?php echo getEvaluationDescription14($musica['puntaje_ritmo'], $musica['puntaje_tempo'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($danza): ?>
        <?php echo getEvaluationDescription15($danza['puntaje_coordinacion'], $danza['puntaje_equilibrio'], $danza['puntaje_control_corporal'], $danza['puntaje_espontaneidad'], $danza['puntaje_creatividad'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($teatro): ?>
        <?php echo getEvaluationDescription16($teatro['puntaje_expresion'], $teatro['puntaje_proyectar_voz'], $teatro['puntaje_control_corporal'], $teatro['puntaje_modular_tonos'], $teatro['puntaje_articulacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <h2>1.3 Comportamiento en el Aula y Nivel de Autonomía</h2>
    <?php if ($evaluacion): ?>
        <p>
            
            <?php echo getEvaluationDescription($evaluacion['pregunta1'], 1); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta2'], 2); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta3'], 3); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta4'], 4); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta5'], 5); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta6'], 6); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta7'], 7); ?>
        </p>
        <p>
            
            <?php echo getEvaluationDescription($evaluacion['pregunta8'], 8); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta9'], 9); ?>
        </p>
        <p>
             
            <?php echo getEvaluationDescription($evaluacion['pregunta10'], 10); ?>
        </p>

    <?php else: ?>
    <?php endif; ?>

    <h2>1.4 Fortalezas y Áreas de Oportunidad</h2>
    <h2>Fortalezas</h2>
    <?php if ($evaluacion): ?>
    
    <p>       
            <?php echo getEvaluationDescription17($evaluacion['pregunta1'], 1); ?>
    </p>
    <p>    
             
            <?php echo getEvaluationDescription17($evaluacion['pregunta2'], 2); ?>
    </p>
    <p>   
            
            <?php echo getEvaluationDescription17($evaluacion['pregunta3'], 3); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17($evaluacion['pregunta4'], 4); ?>
     </p>
    <p>  
           
            <?php echo getEvaluationDescription17($evaluacion['pregunta5'], 5); ?>
     </p>
    <p>  
             
            <?php echo getEvaluationDescription17($evaluacion['pregunta6'], 6); ?>
     </p>
    <p>  
             
            <?php echo getEvaluationDescription17($evaluacion['pregunta7'], 7); ?>
        
    </p>
    <p>        
            <?php echo getEvaluationDescription17($evaluacion['pregunta8'], 8); ?>
    </p>
    <p>    
             
            <?php echo getEvaluationDescription17($evaluacion['pregunta9'], 9); ?>
     </p>
    <p>   
             
            <?php echo getEvaluationDescription17($evaluacion['pregunta10'], 10); ?>
    </p> 
    <?php if ($cuestionario): ?>
        <?php echo getEvaluationDescription18($cuestionario['bienestar_post'], 1); ?>
        </p>
    <p>
        <?php echo getEvaluationDescription18($cuestionario['motivacion_post'], 2); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($lectura): ?>
        <?php echo getEvaluationDescription19($lectura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escritura): ?>
        <?php echo getEvaluationDescription20($escritura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($matematicas): ?>
        <?php echo getEvaluationDescription21($matematicas['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($memoria): ?>
        <?php echo getEvaluationDescription22($memoria['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($funciones): ?>
        <?php echo getEvaluationDescription23($funciones['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($visoespacial): ?>
        <?php echo getEvaluationDescription24($visoespacial['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($atencion): ?>
        <?php echo getEvaluationDescription25($atencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($problemas): ?>
        <?php echo getEvaluationDescription26($problemas['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($retencion): ?>
        <?php echo getEvaluationDescription27($retencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($dibujo): ?>
        <?php echo getEvaluationDescription28($dibujo['puntaje_precision'], $dibujo['puntaje_colores'], $dibujo['puntaje_organizacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escultura): ?>
        <?php echo getEvaluationDescription29($escultura['puntaje_destreza'], $escultura['puntaje_fuerza'], $escultura['puntaje_coordinacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($musica): ?>
        <?php echo getEvaluationDescription30($musica['puntaje_ritmo'], $musica['puntaje_tempo'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($danza): ?>
        <?php echo getEvaluationDescription31($danza['puntaje_coordinacion'], $danza['puntaje_equilibrio'], $danza['puntaje_control_corporal'], $danza['puntaje_espontaneidad'], $danza['puntaje_creatividad'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($teatro): ?>
        <?php echo getEvaluationDescription32($teatro['puntaje_expresion'], $teatro['puntaje_proyectar_voz'], $teatro['puntaje_control_corporal'], $teatro['puntaje_modular_tonos'], $teatro['puntaje_articulacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
    <?php else: ?>
    <?php endif; ?>
    <h2>Áreas de Oportunidad </h2>
    <?php if ($evaluacion): ?>
    
  </p>
    <p>          
            <?php echo getEvaluationDescription17a($evaluacion['pregunta1'], 1); ?>
        
    </p>
    <p>        
            <?php echo getEvaluationDescription17a($evaluacion['pregunta2'], 2); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17a($evaluacion['pregunta3'], 3); ?>
       
     </p>
    <p>        
            <?php echo getEvaluationDescription17a($evaluacion['pregunta4'], 4); ?>
     </p>
    <p>   
             
            <?php echo getEvaluationDescription17a($evaluacion['pregunta5'], 5); ?>
       
     </p>
    <p>        
            <?php echo getEvaluationDescription17a($evaluacion['pregunta6'], 6); ?>
    </p>
    <p>    
            
            <?php echo getEvaluationDescription17a($evaluacion['pregunta7'], 7); ?>
     </p>
    <p>   
            
            <?php echo getEvaluationDescription17a($evaluacion['pregunta8'], 8); ?>
     </p>
    <p>   
            
            <?php echo getEvaluationDescription17a($evaluacion['pregunta9'], 9); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17a($evaluacion['pregunta10'], 10); ?>
       
    <?php if ($cuestionario): ?>
     </p>
    <p>   
        <?php echo getEvaluationDescription18a($cuestionario['bienestar_post'], 1); ?>
        <?php echo getEvaluationDescription18a($cuestionario['motivacion_post'], 2); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($lectura): ?>
        <?php echo getEvaluationDescription19a($lectura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escritura): ?>
        <?php echo getEvaluationDescription20a($escritura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($matematicas): ?>
        <?php echo getEvaluationDescription21a($matematicas['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($memoria): ?>
        <?php echo getEvaluationDescription22a($memoria['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($funciones): ?>
        <?php echo getEvaluationDescription23a($funciones['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($visoespacial): ?>
        <?php echo getEvaluationDescription24a($visoespacial['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($atencion): ?>
        <?php echo getEvaluationDescription25a($atencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($problemas): ?>
        <?php echo getEvaluationDescription26a($problemas['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($retencion): ?>
        <?php echo getEvaluationDescription27a($retencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($dibujo): ?>
        <?php echo getEvaluationDescription28a($dibujo['puntaje_precision'], $dibujo['puntaje_colores'], $dibujo['puntaje_organizacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escultura): ?>
        <?php echo getEvaluationDescription29a($escultura['puntaje_destreza'], $escultura['puntaje_fuerza'], $escultura['puntaje_coordinacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($musica): ?>
        <?php echo getEvaluationDescription30a($musica['puntaje_ritmo'], $musica['puntaje_tempo'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($danza): ?>
        <?php echo getEvaluationDescription31a($danza['puntaje_coordinacion'], $danza['puntaje_equilibrio'], $danza['puntaje_control_corporal'], $danza['puntaje_espontaneidad'], $danza['puntaje_creatividad'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($teatro): ?>
        <?php echo getEvaluationDescription32a($teatro['puntaje_expresion'], $teatro['puntaje_proyectar_voz'], $teatro['puntaje_control_corporal'], $teatro['puntaje_modular_tonos'], $teatro['puntaje_articulacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
    <?php else: ?></p>
    <p>
    <?php endif; ?>
    

</div>
</body>
</html>

    </div>
    <!-- Pestaña de Objetivos -->
    <div id="obj" class="tab-content">
        <h2>2.1 Objetivos</h2>
        <!--ul>
            <p>Fortalecer habilidades sociolaborales y promover la autonomía en la ejecución de tareas.</p>
            <p>Mejorar la velocidad y fluidez en la lectura mediante estrategias dinámicas.</p>
            <p>Optimizar la precisión y eficiencia en la manipulación de materiales.</p>
        </ul-->
    <?php if ($evaluacion): ?>
         <p>          
            <?php echo getEvaluationDescription17b($evaluacion['pregunta1'], 1); ?>    
    </p>

    <p>        
            <?php echo getEvaluationDescription17b($evaluacion['pregunta2'], 2); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17b($evaluacion['pregunta3'], 3); ?>
       
     </p>
    <p>        
            <?php echo getEvaluationDescription17b($evaluacion['pregunta4'], 4); ?>
     </p>
    <p>   
             
            <?php echo getEvaluationDescription17b($evaluacion['pregunta5'], 5); ?>
       
     </p>
    <p>        
            <?php echo getEvaluationDescription17b($evaluacion['pregunta6'], 6); ?>
    </p>
    <p>    
            
            <?php echo getEvaluationDescription17b($evaluacion['pregunta7'], 7); ?>
     </p>
    <p>   
            
            <?php echo getEvaluationDescription17b($evaluacion['pregunta8'], 8); ?>
     </p>
    <p>   
            
            <?php echo getEvaluationDescription17b($evaluacion['pregunta9'], 9); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17b($evaluacion['pregunta10'], 10); ?>
     </p>
         <?php else: ?>
    <?php endif; ?>
    <p>   
        <?php if ($cuestionario): ?>
        <?php echo getEvaluationDescription18b($cuestionario['bienestar_post'], 1); ?>
        <?php echo getEvaluationDescription18b($cuestionario['motivacion_post'], 2); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($lectura): ?>
        <?php echo getEvaluationDescription19b($lectura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escritura): ?>
        <?php echo getEvaluationDescription20b($escritura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($matematicas): ?>
        <?php echo getEvaluationDescription21b($matematicas['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($memoria): ?>
        <?php echo getEvaluationDescription22b($memoria['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($funciones): ?>
        <?php echo getEvaluationDescription23b($funciones['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($visoespacial): ?>
        <?php echo getEvaluationDescription24b($visoespacial['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($atencion): ?>
        <?php echo getEvaluationDescription25b($atencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($problemas): ?>
        <?php echo getEvaluationDescription26b($problemas['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($retencion): ?>
        <?php echo getEvaluationDescription27b($retencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($dibujo): ?>
        <?php echo getEvaluationDescription28b($dibujo['puntaje_precision'], $dibujo['puntaje_colores'], $dibujo['puntaje_organizacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escultura): ?>
        <?php echo getEvaluationDescription29b($escultura['puntaje_destreza'], $escultura['puntaje_fuerza'], $escultura['puntaje_coordinacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($musica): ?>
        <?php echo getEvaluationDescription30b($musica['puntaje_ritmo'], $musica['puntaje_tempo'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($danza): ?>
        <?php echo getEvaluationDescription31b($danza['puntaje_coordinacion'], $danza['puntaje_equilibrio'], $danza['puntaje_control_corporal'], $danza['puntaje_espontaneidad'], $danza['puntaje_creatividad'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($teatro): ?>
        <?php echo getEvaluationDescription32b($teatro['puntaje_expresion'], $teatro['puntaje_proyectar_voz'], $teatro['puntaje_control_corporal'], $teatro['puntaje_modular_tonos'], $teatro['puntaje_articulacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
    <!--?php else: ?></p-->
    <p>
    <!--?php endif; ?-->
    </div>
    <!-- Pestaña de Estrategias de Intervención -->
    <div id="estrat" class="tab-content">
        <h2>2.2 Estrategias de Intervención</h2>
        <!--ul>
            <p>Implementar modelado conductual y aprendizaje por imitación.</p>
            <p>Utilizar guías visuales y esquemas secuenciales para mejorar la organización.</p>
            <p>Aplicar técnicas de economía de fichas y reforzamiento positivo.</p>
            <p>Entrenar en la toma de decisiones mediante situaciones prácticas.</p>
            <p>Ejercitar la motricidad fina para optimizar el uso de herramientas y materiales.</p>
        </ul-->
             <p> 
             <?php if ($evaluacion): ?>         
            <?php echo getEvaluationDescription17c($evaluacion['pregunta1'], 1); ?>
        
    </p>
    <p>        
            <?php echo getEvaluationDescription17c($evaluacion['pregunta2'], 2); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17c($evaluacion['pregunta3'], 3); ?>
       
     </p>
    <p>        
            <?php echo getEvaluationDescription17c($evaluacion['pregunta4'], 4); ?>
     </p>
    <p>   
             
            <?php echo getEvaluationDescription17c($evaluacion['pregunta5'], 5); ?>
       
     </p>
    <p>        
            <?php echo getEvaluationDescription17c($evaluacion['pregunta6'], 6); ?>
    </p>
    <p>    
            
            <?php echo getEvaluationDescription17c($evaluacion['pregunta7'], 7); ?>
     </p>
    <p>   
            
            <?php echo getEvaluationDescription17c($evaluacion['pregunta8'], 8); ?>
     </p>
    <p>   
            
            <?php echo getEvaluationDescription17c($evaluacion['pregunta9'], 9); ?>
        
     </p>
    <p>       
            <?php echo getEvaluationDescription17c($evaluacion['pregunta10'], 10); ?>
             </p>
<?php else: ?>
    <?php endif; ?>
       
    <?php if ($cuestionario): ?>
    <p>   
        <?php echo getEvaluationDescription18c($cuestionario['bienestar_post'], 1); ?>
        <?php echo getEvaluationDescription18c($cuestionario['motivacion_post'], 2); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($lectura): ?>
        <?php echo getEvaluationDescription19c($lectura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escritura): ?>
        <?php echo getEvaluationDescription20c($escritura['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($matematicas): ?>
        <?php echo getEvaluationDescription21c($matematicas['score'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($memoria): ?>
        <?php echo getEvaluationDescription22c($memoria['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($funciones): ?>
        <?php echo getEvaluationDescription23c($funciones['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($visoespacial): ?>
        <?php echo getEvaluationDescription24c($visoespacial['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($atencion): ?>
        <?php echo getEvaluationDescription25c($atencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($problemas): ?>
        <?php echo getEvaluationDescription26c($problemas['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($retencion): ?>
        <?php echo getEvaluationDescription27c($retencion['aciertos'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($dibujo): ?>
        <?php echo getEvaluationDescription28c($dibujo['puntaje_precision'], $dibujo['puntaje_colores'], $dibujo['puntaje_organizacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($escultura): ?>
        <?php echo getEvaluationDescription29c($escultura['puntaje_destreza'], $escultura['puntaje_fuerza'], $escultura['puntaje_coordinacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($musica): ?>
        <?php echo getEvaluationDescription30c($musica['puntaje_ritmo'], $musica['puntaje_tempo'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($danza): ?>
        <?php echo getEvaluationDescription31c($danza['puntaje_coordinacion'], $danza['puntaje_equilibrio'], $danza['puntaje_control_corporal'], $danza['puntaje_espontaneidad'], $danza['puntaje_creatividad'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    <p>
    <?php if ($teatro): ?>
        <?php echo getEvaluationDescription32c($teatro['puntaje_expresion'], $teatro['puntaje_proyectar_voz'], $teatro['puntaje_control_corporal'], $teatro['puntaje_modular_tonos'], $teatro['puntaje_articulacion'], 1); ?>
    <?php else: ?>
    <?php endif; ?>
</p>
    </div>
</p>
</p></div></p></p></div></p></p></ul></div>
</div>
</body>
</html>